/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a through resource statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThroughResourcesStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<ThroughResourcesStatement.Builder, ThroughResourcesStatement> {
    private static final SdkField<ResourceStatement> RESOURCE_STATEMENT_FIELD = SdkField
            .<ResourceStatement> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceStatement")
            .getter(getter(ThroughResourcesStatement::resourceStatement))
            .setter(setter(Builder::resourceStatement))
            .constructor(ResourceStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatement")
                    .unmarshallLocationName("resourceStatement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_STATEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ResourceStatement", RESOURCE_STATEMENT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ResourceStatement resourceStatement;

    private ThroughResourcesStatement(BuilderImpl builder) {
        this.resourceStatement = builder.resourceStatement;
    }

    /**
     * <p>
     * The resource statement.
     * </p>
     * 
     * @return The resource statement.
     */
    public final ResourceStatement resourceStatement() {
        return resourceStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThroughResourcesStatement)) {
            return false;
        }
        ThroughResourcesStatement other = (ThroughResourcesStatement) obj;
        return Objects.equals(resourceStatement(), other.resourceStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThroughResourcesStatement").add("ResourceStatement", resourceStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceStatement":
            return Optional.ofNullable(clazz.cast(resourceStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ThroughResourcesStatement, T> g) {
        return obj -> g.apply((ThroughResourcesStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThroughResourcesStatement> {
        /**
         * <p>
         * The resource statement.
         * </p>
         * 
         * @param resourceStatement
         *        The resource statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatement(ResourceStatement resourceStatement);

        /**
         * <p>
         * The resource statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceStatement.Builder} avoiding the
         * need to create one manually via {@link ResourceStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceStatement(ResourceStatement)}.
         * 
         * @param resourceStatement
         *        a consumer that will call methods on {@link ResourceStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceStatement(ResourceStatement)
         */
        default Builder resourceStatement(Consumer<ResourceStatement.Builder> resourceStatement) {
            return resourceStatement(ResourceStatement.builder().applyMutation(resourceStatement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceStatement resourceStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(ThroughResourcesStatement model) {
            resourceStatement(model.resourceStatement);
        }

        public final ResourceStatement.Builder getResourceStatement() {
            return resourceStatement != null ? resourceStatement.toBuilder() : null;
        }

        public final void setResourceStatement(ResourceStatement.BuilderImpl resourceStatement) {
            this.resourceStatement = resourceStatement != null ? resourceStatement.build() : null;
        }

        @Override
        public final Builder resourceStatement(ResourceStatement resourceStatement) {
            this.resourceStatement = resourceStatement;
            return this;
        }

        @Override
        public ThroughResourcesStatement build() {
            return new ThroughResourcesStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
