/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointServiceConfigurationRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcEndpointServiceConfigurationRequest.Builder, ModifyVpcEndpointServiceConfigurationRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceId")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("ServiceId").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("PrivateDnsName").build()).build();

    private static final SdkField<Boolean> REMOVE_PRIVATE_DNS_NAME_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemovePrivateDnsName")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::removePrivateDnsName))
            .setter(setter(Builder::removePrivateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovePrivateDnsName")
                    .unmarshallLocationName("RemovePrivateDnsName").build()).build();

    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptanceRequired")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::acceptanceRequired))
            .setter(setter(Builder::acceptanceRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired")
                    .unmarshallLocationName("AcceptanceRequired").build()).build();

    private static final SdkField<List<String>> ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddNetworkLoadBalancerArns")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::addNetworkLoadBalancerArns))
            .setter(setter(Builder::addNetworkLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddNetworkLoadBalancerArn")
                    .unmarshallLocationName("AddNetworkLoadBalancerArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveNetworkLoadBalancerArns")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::removeNetworkLoadBalancerArns))
            .setter(setter(Builder::removeNetworkLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveNetworkLoadBalancerArn")
                    .unmarshallLocationName("RemoveNetworkLoadBalancerArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ADD_GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddGatewayLoadBalancerArns")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::addGatewayLoadBalancerArns))
            .setter(setter(Builder::addGatewayLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddGatewayLoadBalancerArn")
                    .unmarshallLocationName("AddGatewayLoadBalancerArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveGatewayLoadBalancerArns")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::removeGatewayLoadBalancerArns))
            .setter(setter(Builder::removeGatewayLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveGatewayLoadBalancerArn")
                    .unmarshallLocationName("RemoveGatewayLoadBalancerArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ADD_SUPPORTED_IP_ADDRESS_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddSupportedIpAddressTypes")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::addSupportedIpAddressTypes))
            .setter(setter(Builder::addSupportedIpAddressTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSupportedIpAddressType")
                    .unmarshallLocationName("AddSupportedIpAddressType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_SUPPORTED_IP_ADDRESS_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveSupportedIpAddressTypes")
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::removeSupportedIpAddressTypes))
            .setter(setter(Builder::removeSupportedIpAddressTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSupportedIpAddressType")
                    .unmarshallLocationName("RemoveSupportedIpAddressType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            SERVICE_ID_FIELD, PRIVATE_DNS_NAME_FIELD, REMOVE_PRIVATE_DNS_NAME_FIELD, ACCEPTANCE_REQUIRED_FIELD,
            ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD, REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD, ADD_GATEWAY_LOAD_BALANCER_ARNS_FIELD,
            REMOVE_GATEWAY_LOAD_BALANCER_ARNS_FIELD, ADD_SUPPORTED_IP_ADDRESS_TYPES_FIELD,
            REMOVE_SUPPORTED_IP_ADDRESS_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DryRun", DRY_RUN_FIELD);
                    put("ServiceId", SERVICE_ID_FIELD);
                    put("PrivateDnsName", PRIVATE_DNS_NAME_FIELD);
                    put("RemovePrivateDnsName", REMOVE_PRIVATE_DNS_NAME_FIELD);
                    put("AcceptanceRequired", ACCEPTANCE_REQUIRED_FIELD);
                    put("AddNetworkLoadBalancerArn", ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD);
                    put("RemoveNetworkLoadBalancerArn", REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD);
                    put("AddGatewayLoadBalancerArn", ADD_GATEWAY_LOAD_BALANCER_ARNS_FIELD);
                    put("RemoveGatewayLoadBalancerArn", REMOVE_GATEWAY_LOAD_BALANCER_ARNS_FIELD);
                    put("AddSupportedIpAddressType", ADD_SUPPORTED_IP_ADDRESS_TYPES_FIELD);
                    put("RemoveSupportedIpAddressType", REMOVE_SUPPORTED_IP_ADDRESS_TYPES_FIELD);
                }
            });

    private final Boolean dryRun;

    private final String serviceId;

    private final String privateDnsName;

    private final Boolean removePrivateDnsName;

    private final Boolean acceptanceRequired;

    private final List<String> addNetworkLoadBalancerArns;

    private final List<String> removeNetworkLoadBalancerArns;

    private final List<String> addGatewayLoadBalancerArns;

    private final List<String> removeGatewayLoadBalancerArns;

    private final List<String> addSupportedIpAddressTypes;

    private final List<String> removeSupportedIpAddressTypes;

    private ModifyVpcEndpointServiceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.serviceId = builder.serviceId;
        this.privateDnsName = builder.privateDnsName;
        this.removePrivateDnsName = builder.removePrivateDnsName;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.addNetworkLoadBalancerArns = builder.addNetworkLoadBalancerArns;
        this.removeNetworkLoadBalancerArns = builder.removeNetworkLoadBalancerArns;
        this.addGatewayLoadBalancerArns = builder.addGatewayLoadBalancerArns;
        this.removeGatewayLoadBalancerArns = builder.removeGatewayLoadBalancerArns;
        this.addSupportedIpAddressTypes = builder.addSupportedIpAddressTypes;
        this.removeSupportedIpAddressTypes = builder.removeSupportedIpAddressTypes;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the service.
     * </p>
     * 
     * @return The ID of the service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * (Interface endpoint configuration) The private DNS name to assign to the endpoint service.
     * </p>
     * 
     * @return (Interface endpoint configuration) The private DNS name to assign to the endpoint service.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * (Interface endpoint configuration) Removes the private DNS name of the endpoint service.
     * </p>
     * 
     * @return (Interface endpoint configuration) Removes the private DNS name of the endpoint service.
     */
    public final Boolean removePrivateDnsName() {
        return removePrivateDnsName;
    }

    /**
     * <p>
     * Indicates whether requests to create an endpoint to your service must be accepted.
     * </p>
     * 
     * @return Indicates whether requests to create an endpoint to your service must be accepted.
     */
    public final Boolean acceptanceRequired() {
        return acceptanceRequired;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddNetworkLoadBalancerArns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddNetworkLoadBalancerArns() {
        return addNetworkLoadBalancerArns != null && !(addNetworkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddNetworkLoadBalancerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
     */
    public final List<String> addNetworkLoadBalancerArns() {
        return addNetworkLoadBalancerArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveNetworkLoadBalancerArns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveNetworkLoadBalancerArns() {
        return removeNetworkLoadBalancerArns != null && !(removeNetworkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveNetworkLoadBalancerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
     */
    public final List<String> removeNetworkLoadBalancerArns() {
        return removeNetworkLoadBalancerArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddGatewayLoadBalancerArns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddGatewayLoadBalancerArns() {
        return addGatewayLoadBalancerArns != null && !(addGatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddGatewayLoadBalancerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration.
     */
    public final List<String> addGatewayLoadBalancerArns() {
        return addGatewayLoadBalancerArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveGatewayLoadBalancerArns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveGatewayLoadBalancerArns() {
        return removeGatewayLoadBalancerArns != null && !(removeGatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveGatewayLoadBalancerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration.
     */
    public final List<String> removeGatewayLoadBalancerArns() {
        return removeGatewayLoadBalancerArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSupportedIpAddressTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddSupportedIpAddressTypes() {
        return addSupportedIpAddressTypes != null && !(addSupportedIpAddressTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP address types to add to your service configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSupportedIpAddressTypes} method.
     * </p>
     * 
     * @return The IP address types to add to your service configuration.
     */
    public final List<String> addSupportedIpAddressTypes() {
        return addSupportedIpAddressTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSupportedIpAddressTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveSupportedIpAddressTypes() {
        return removeSupportedIpAddressTypes != null && !(removeSupportedIpAddressTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP address types to remove from your service configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSupportedIpAddressTypes} method.
     * </p>
     * 
     * @return The IP address types to remove from your service configuration.
     */
    public final List<String> removeSupportedIpAddressTypes() {
        return removeSupportedIpAddressTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(removePrivateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddNetworkLoadBalancerArns() ? addNetworkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveNetworkLoadBalancerArns() ? removeNetworkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddGatewayLoadBalancerArns() ? addGatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveGatewayLoadBalancerArns() ? removeGatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSupportedIpAddressTypes() ? addSupportedIpAddressTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSupportedIpAddressTypes() ? removeSupportedIpAddressTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServiceConfigurationRequest)) {
            return false;
        }
        ModifyVpcEndpointServiceConfigurationRequest other = (ModifyVpcEndpointServiceConfigurationRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(serviceId(), other.serviceId())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(removePrivateDnsName(), other.removePrivateDnsName())
                && Objects.equals(acceptanceRequired(), other.acceptanceRequired())
                && hasAddNetworkLoadBalancerArns() == other.hasAddNetworkLoadBalancerArns()
                && Objects.equals(addNetworkLoadBalancerArns(), other.addNetworkLoadBalancerArns())
                && hasRemoveNetworkLoadBalancerArns() == other.hasRemoveNetworkLoadBalancerArns()
                && Objects.equals(removeNetworkLoadBalancerArns(), other.removeNetworkLoadBalancerArns())
                && hasAddGatewayLoadBalancerArns() == other.hasAddGatewayLoadBalancerArns()
                && Objects.equals(addGatewayLoadBalancerArns(), other.addGatewayLoadBalancerArns())
                && hasRemoveGatewayLoadBalancerArns() == other.hasRemoveGatewayLoadBalancerArns()
                && Objects.equals(removeGatewayLoadBalancerArns(), other.removeGatewayLoadBalancerArns())
                && hasAddSupportedIpAddressTypes() == other.hasAddSupportedIpAddressTypes()
                && Objects.equals(addSupportedIpAddressTypes(), other.addSupportedIpAddressTypes())
                && hasRemoveSupportedIpAddressTypes() == other.hasRemoveSupportedIpAddressTypes()
                && Objects.equals(removeSupportedIpAddressTypes(), other.removeSupportedIpAddressTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ModifyVpcEndpointServiceConfigurationRequest")
                .add("DryRun", dryRun())
                .add("ServiceId", serviceId())
                .add("PrivateDnsName", privateDnsName())
                .add("RemovePrivateDnsName", removePrivateDnsName())
                .add("AcceptanceRequired", acceptanceRequired())
                .add("AddNetworkLoadBalancerArns", hasAddNetworkLoadBalancerArns() ? addNetworkLoadBalancerArns() : null)
                .add("RemoveNetworkLoadBalancerArns", hasRemoveNetworkLoadBalancerArns() ? removeNetworkLoadBalancerArns() : null)
                .add("AddGatewayLoadBalancerArns", hasAddGatewayLoadBalancerArns() ? addGatewayLoadBalancerArns() : null)
                .add("RemoveGatewayLoadBalancerArns", hasRemoveGatewayLoadBalancerArns() ? removeGatewayLoadBalancerArns() : null)
                .add("AddSupportedIpAddressTypes", hasAddSupportedIpAddressTypes() ? addSupportedIpAddressTypes() : null)
                .add("RemoveSupportedIpAddressTypes", hasRemoveSupportedIpAddressTypes() ? removeSupportedIpAddressTypes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "RemovePrivateDnsName":
            return Optional.ofNullable(clazz.cast(removePrivateDnsName()));
        case "AcceptanceRequired":
            return Optional.ofNullable(clazz.cast(acceptanceRequired()));
        case "AddNetworkLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(addNetworkLoadBalancerArns()));
        case "RemoveNetworkLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(removeNetworkLoadBalancerArns()));
        case "AddGatewayLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(addGatewayLoadBalancerArns()));
        case "RemoveGatewayLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(removeGatewayLoadBalancerArns()));
        case "AddSupportedIpAddressTypes":
            return Optional.ofNullable(clazz.cast(addSupportedIpAddressTypes()));
        case "RemoveSupportedIpAddressTypes":
            return Optional.ofNullable(clazz.cast(removeSupportedIpAddressTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServiceConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServiceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcEndpointServiceConfigurationRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * (Interface endpoint configuration) The private DNS name to assign to the endpoint service.
         * </p>
         * 
         * @param privateDnsName
         *        (Interface endpoint configuration) The private DNS name to assign to the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * (Interface endpoint configuration) Removes the private DNS name of the endpoint service.
         * </p>
         * 
         * @param removePrivateDnsName
         *        (Interface endpoint configuration) Removes the private DNS name of the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removePrivateDnsName(Boolean removePrivateDnsName);

        /**
         * <p>
         * Indicates whether requests to create an endpoint to your service must be accepted.
         * </p>
         * 
         * @param acceptanceRequired
         *        Indicates whether requests to create an endpoint to your service must be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceRequired(Boolean acceptanceRequired);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
         * </p>
         * 
         * @param addNetworkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
         * </p>
         * 
         * @param addNetworkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkLoadBalancerArns(String... addNetworkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
         * </p>
         * 
         * @param removeNetworkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
         * </p>
         * 
         * @param removeNetworkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkLoadBalancerArns(String... removeNetworkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration.
         * </p>
         * 
         * @param addGatewayLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addGatewayLoadBalancerArns(Collection<String> addGatewayLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration.
         * </p>
         * 
         * @param addGatewayLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addGatewayLoadBalancerArns(String... addGatewayLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration.
         * </p>
         * 
         * @param removeGatewayLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeGatewayLoadBalancerArns(Collection<String> removeGatewayLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration.
         * </p>
         * 
         * @param removeGatewayLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeGatewayLoadBalancerArns(String... removeGatewayLoadBalancerArns);

        /**
         * <p>
         * The IP address types to add to your service configuration.
         * </p>
         * 
         * @param addSupportedIpAddressTypes
         *        The IP address types to add to your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSupportedIpAddressTypes(Collection<String> addSupportedIpAddressTypes);

        /**
         * <p>
         * The IP address types to add to your service configuration.
         * </p>
         * 
         * @param addSupportedIpAddressTypes
         *        The IP address types to add to your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSupportedIpAddressTypes(String... addSupportedIpAddressTypes);

        /**
         * <p>
         * The IP address types to remove from your service configuration.
         * </p>
         * 
         * @param removeSupportedIpAddressTypes
         *        The IP address types to remove from your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSupportedIpAddressTypes(Collection<String> removeSupportedIpAddressTypes);

        /**
         * <p>
         * The IP address types to remove from your service configuration.
         * </p>
         * 
         * @param removeSupportedIpAddressTypes
         *        The IP address types to remove from your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSupportedIpAddressTypes(String... removeSupportedIpAddressTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String serviceId;

        private String privateDnsName;

        private Boolean removePrivateDnsName;

        private Boolean acceptanceRequired;

        private List<String> addNetworkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeNetworkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> addGatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeGatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> addSupportedIpAddressTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSupportedIpAddressTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServiceConfigurationRequest model) {
            super(model);
            dryRun(model.dryRun);
            serviceId(model.serviceId);
            privateDnsName(model.privateDnsName);
            removePrivateDnsName(model.removePrivateDnsName);
            acceptanceRequired(model.acceptanceRequired);
            addNetworkLoadBalancerArns(model.addNetworkLoadBalancerArns);
            removeNetworkLoadBalancerArns(model.removeNetworkLoadBalancerArns);
            addGatewayLoadBalancerArns(model.addGatewayLoadBalancerArns);
            removeGatewayLoadBalancerArns(model.removeGatewayLoadBalancerArns);
            addSupportedIpAddressTypes(model.addSupportedIpAddressTypes);
            removeSupportedIpAddressTypes(model.removeSupportedIpAddressTypes);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final Boolean getRemovePrivateDnsName() {
            return removePrivateDnsName;
        }

        public final void setRemovePrivateDnsName(Boolean removePrivateDnsName) {
            this.removePrivateDnsName = removePrivateDnsName;
        }

        @Override
        public final Builder removePrivateDnsName(Boolean removePrivateDnsName) {
            this.removePrivateDnsName = removePrivateDnsName;
            return this;
        }

        public final Boolean getAcceptanceRequired() {
            return acceptanceRequired;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final Collection<String> getAddNetworkLoadBalancerArns() {
            if (addNetworkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return addNetworkLoadBalancerArns;
        }

        public final void setAddNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns = ValueStringListCopier.copy(addNetworkLoadBalancerArns);
        }

        @Override
        public final Builder addNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns = ValueStringListCopier.copy(addNetworkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addNetworkLoadBalancerArns(String... addNetworkLoadBalancerArns) {
            addNetworkLoadBalancerArns(Arrays.asList(addNetworkLoadBalancerArns));
            return this;
        }

        public final Collection<String> getRemoveNetworkLoadBalancerArns() {
            if (removeNetworkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return removeNetworkLoadBalancerArns;
        }

        public final void setRemoveNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns = ValueStringListCopier.copy(removeNetworkLoadBalancerArns);
        }

        @Override
        public final Builder removeNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns = ValueStringListCopier.copy(removeNetworkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeNetworkLoadBalancerArns(String... removeNetworkLoadBalancerArns) {
            removeNetworkLoadBalancerArns(Arrays.asList(removeNetworkLoadBalancerArns));
            return this;
        }

        public final Collection<String> getAddGatewayLoadBalancerArns() {
            if (addGatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return addGatewayLoadBalancerArns;
        }

        public final void setAddGatewayLoadBalancerArns(Collection<String> addGatewayLoadBalancerArns) {
            this.addGatewayLoadBalancerArns = ValueStringListCopier.copy(addGatewayLoadBalancerArns);
        }

        @Override
        public final Builder addGatewayLoadBalancerArns(Collection<String> addGatewayLoadBalancerArns) {
            this.addGatewayLoadBalancerArns = ValueStringListCopier.copy(addGatewayLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addGatewayLoadBalancerArns(String... addGatewayLoadBalancerArns) {
            addGatewayLoadBalancerArns(Arrays.asList(addGatewayLoadBalancerArns));
            return this;
        }

        public final Collection<String> getRemoveGatewayLoadBalancerArns() {
            if (removeGatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return removeGatewayLoadBalancerArns;
        }

        public final void setRemoveGatewayLoadBalancerArns(Collection<String> removeGatewayLoadBalancerArns) {
            this.removeGatewayLoadBalancerArns = ValueStringListCopier.copy(removeGatewayLoadBalancerArns);
        }

        @Override
        public final Builder removeGatewayLoadBalancerArns(Collection<String> removeGatewayLoadBalancerArns) {
            this.removeGatewayLoadBalancerArns = ValueStringListCopier.copy(removeGatewayLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeGatewayLoadBalancerArns(String... removeGatewayLoadBalancerArns) {
            removeGatewayLoadBalancerArns(Arrays.asList(removeGatewayLoadBalancerArns));
            return this;
        }

        public final Collection<String> getAddSupportedIpAddressTypes() {
            if (addSupportedIpAddressTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return addSupportedIpAddressTypes;
        }

        public final void setAddSupportedIpAddressTypes(Collection<String> addSupportedIpAddressTypes) {
            this.addSupportedIpAddressTypes = ValueStringListCopier.copy(addSupportedIpAddressTypes);
        }

        @Override
        public final Builder addSupportedIpAddressTypes(Collection<String> addSupportedIpAddressTypes) {
            this.addSupportedIpAddressTypes = ValueStringListCopier.copy(addSupportedIpAddressTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSupportedIpAddressTypes(String... addSupportedIpAddressTypes) {
            addSupportedIpAddressTypes(Arrays.asList(addSupportedIpAddressTypes));
            return this;
        }

        public final Collection<String> getRemoveSupportedIpAddressTypes() {
            if (removeSupportedIpAddressTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSupportedIpAddressTypes;
        }

        public final void setRemoveSupportedIpAddressTypes(Collection<String> removeSupportedIpAddressTypes) {
            this.removeSupportedIpAddressTypes = ValueStringListCopier.copy(removeSupportedIpAddressTypes);
        }

        @Override
        public final Builder removeSupportedIpAddressTypes(Collection<String> removeSupportedIpAddressTypes) {
            this.removeSupportedIpAddressTypes = ValueStringListCopier.copy(removeSupportedIpAddressTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSupportedIpAddressTypes(String... removeSupportedIpAddressTypes) {
            removeSupportedIpAddressTypes(Arrays.asList(removeSupportedIpAddressTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointServiceConfigurationRequest build() {
            return new ModifyVpcEndpointServiceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
