/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcBlockPublicAccessExclusionRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcBlockPublicAccessExclusionRequest.Builder, ModifyVpcBlockPublicAccessExclusionRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyVpcBlockPublicAccessExclusionRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> EXCLUSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExclusionId")
            .getter(getter(ModifyVpcBlockPublicAccessExclusionRequest::exclusionId))
            .setter(setter(Builder::exclusionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionId")
                    .unmarshallLocationName("ExclusionId").build()).build();

    private static final SdkField<String> INTERNET_GATEWAY_EXCLUSION_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InternetGatewayExclusionMode")
            .getter(getter(ModifyVpcBlockPublicAccessExclusionRequest::internetGatewayExclusionModeAsString))
            .setter(setter(Builder::internetGatewayExclusionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayExclusionMode")
                    .unmarshallLocationName("InternetGatewayExclusionMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            EXCLUSION_ID_FIELD, INTERNET_GATEWAY_EXCLUSION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DryRun", DRY_RUN_FIELD);
                    put("ExclusionId", EXCLUSION_ID_FIELD);
                    put("InternetGatewayExclusionMode", INTERNET_GATEWAY_EXCLUSION_MODE_FIELD);
                }
            });

    private final Boolean dryRun;

    private final String exclusionId;

    private final String internetGatewayExclusionMode;

    private ModifyVpcBlockPublicAccessExclusionRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.exclusionId = builder.exclusionId;
        this.internetGatewayExclusionMode = builder.internetGatewayExclusionMode;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of an exclusion.
     * </p>
     * 
     * @return The ID of an exclusion.
     */
    public final String exclusionId() {
        return exclusionId;
    }

    /**
     * <p>
     * The exclusion mode for internet gateway traffic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bidirectional-access-allowed</code>: Allow all internet traffic to and from the excluded VPCs and subnets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress-access-allowed</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block
     * inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is set to
     * Bidirectional.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayExclusionMode} will return {@link InternetGatewayExclusionMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #internetGatewayExclusionModeAsString}.
     * </p>
     * 
     * @return The exclusion mode for internet gateway traffic.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bidirectional-access-allowed</code>: Allow all internet traffic to and from the excluded VPCs and
     *         subnets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress-access-allowed</code>: Allow outbound internet traffic from the excluded VPCs and subnets.
     *         Block inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public
     *         Access is set to Bidirectional.
     *         </p>
     *         </li>
     * @see InternetGatewayExclusionMode
     */
    public final InternetGatewayExclusionMode internetGatewayExclusionMode() {
        return InternetGatewayExclusionMode.fromValue(internetGatewayExclusionMode);
    }

    /**
     * <p>
     * The exclusion mode for internet gateway traffic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bidirectional-access-allowed</code>: Allow all internet traffic to and from the excluded VPCs and subnets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>egress-access-allowed</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block
     * inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is set to
     * Bidirectional.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayExclusionMode} will return {@link InternetGatewayExclusionMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #internetGatewayExclusionModeAsString}.
     * </p>
     * 
     * @return The exclusion mode for internet gateway traffic.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bidirectional-access-allowed</code>: Allow all internet traffic to and from the excluded VPCs and
     *         subnets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>egress-access-allowed</code>: Allow outbound internet traffic from the excluded VPCs and subnets.
     *         Block inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public
     *         Access is set to Bidirectional.
     *         </p>
     *         </li>
     * @see InternetGatewayExclusionMode
     */
    public final String internetGatewayExclusionModeAsString() {
        return internetGatewayExclusionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(exclusionId());
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayExclusionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcBlockPublicAccessExclusionRequest)) {
            return false;
        }
        ModifyVpcBlockPublicAccessExclusionRequest other = (ModifyVpcBlockPublicAccessExclusionRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(exclusionId(), other.exclusionId())
                && Objects.equals(internetGatewayExclusionModeAsString(), other.internetGatewayExclusionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcBlockPublicAccessExclusionRequest").add("DryRun", dryRun())
                .add("ExclusionId", exclusionId()).add("InternetGatewayExclusionMode", internetGatewayExclusionModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ExclusionId":
            return Optional.ofNullable(clazz.cast(exclusionId()));
        case "InternetGatewayExclusionMode":
            return Optional.ofNullable(clazz.cast(internetGatewayExclusionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcBlockPublicAccessExclusionRequest, T> g) {
        return obj -> g.apply((ModifyVpcBlockPublicAccessExclusionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcBlockPublicAccessExclusionRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of an exclusion.
         * </p>
         * 
         * @param exclusionId
         *        The ID of an exclusion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionId(String exclusionId);

        /**
         * <p>
         * The exclusion mode for internet gateway traffic.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bidirectional-access-allowed</code>: Allow all internet traffic to and from the excluded VPCs and
         * subnets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress-access-allowed</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block
         * inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is set
         * to Bidirectional.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayExclusionMode
         *        The exclusion mode for internet gateway traffic.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bidirectional-access-allowed</code>: Allow all internet traffic to and from the excluded VPCs
         *        and subnets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress-access-allowed</code>: Allow outbound internet traffic from the excluded VPCs and
         *        subnets. Block inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block
         *        Public Access is set to Bidirectional.
         *        </p>
         *        </li>
         * @see InternetGatewayExclusionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternetGatewayExclusionMode
         */
        Builder internetGatewayExclusionMode(String internetGatewayExclusionMode);

        /**
         * <p>
         * The exclusion mode for internet gateway traffic.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bidirectional-access-allowed</code>: Allow all internet traffic to and from the excluded VPCs and
         * subnets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>egress-access-allowed</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block
         * inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is set
         * to Bidirectional.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayExclusionMode
         *        The exclusion mode for internet gateway traffic.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bidirectional-access-allowed</code>: Allow all internet traffic to and from the excluded VPCs
         *        and subnets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>egress-access-allowed</code>: Allow outbound internet traffic from the excluded VPCs and
         *        subnets. Block inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block
         *        Public Access is set to Bidirectional.
         *        </p>
         *        </li>
         * @see InternetGatewayExclusionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternetGatewayExclusionMode
         */
        Builder internetGatewayExclusionMode(InternetGatewayExclusionMode internetGatewayExclusionMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String exclusionId;

        private String internetGatewayExclusionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcBlockPublicAccessExclusionRequest model) {
            super(model);
            dryRun(model.dryRun);
            exclusionId(model.exclusionId);
            internetGatewayExclusionMode(model.internetGatewayExclusionMode);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getExclusionId() {
            return exclusionId;
        }

        public final void setExclusionId(String exclusionId) {
            this.exclusionId = exclusionId;
        }

        @Override
        public final Builder exclusionId(String exclusionId) {
            this.exclusionId = exclusionId;
            return this;
        }

        public final String getInternetGatewayExclusionMode() {
            return internetGatewayExclusionMode;
        }

        public final void setInternetGatewayExclusionMode(String internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode = internetGatewayExclusionMode;
        }

        @Override
        public final Builder internetGatewayExclusionMode(String internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode = internetGatewayExclusionMode;
            return this;
        }

        @Override
        public final Builder internetGatewayExclusionMode(InternetGatewayExclusionMode internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode(internetGatewayExclusionMode == null ? null : internetGatewayExclusionMode
                    .toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcBlockPublicAccessExclusionRequest build() {
            return new ModifyVpcBlockPublicAccessExclusionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
