/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance state change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceStateChange implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceStateChange.Builder, InstanceStateChange> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(InstanceStateChange::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<InstanceState> CURRENT_STATE_FIELD = SdkField
            .<InstanceState> builder(MarshallingType.SDK_POJO)
            .memberName("CurrentState")
            .getter(getter(InstanceStateChange::currentState))
            .setter(setter(Builder::currentState))
            .constructor(InstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState")
                    .unmarshallLocationName("currentState").build()).build();

    private static final SdkField<InstanceState> PREVIOUS_STATE_FIELD = SdkField
            .<InstanceState> builder(MarshallingType.SDK_POJO)
            .memberName("PreviousState")
            .getter(getter(InstanceStateChange::previousState))
            .setter(setter(Builder::previousState))
            .constructor(InstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousState")
                    .unmarshallLocationName("previousState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CURRENT_STATE_FIELD, PREVIOUS_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("CurrentState", CURRENT_STATE_FIELD);
                    put("PreviousState", PREVIOUS_STATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final InstanceState currentState;

    private final InstanceState previousState;

    private InstanceStateChange(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.currentState = builder.currentState;
        this.previousState = builder.previousState;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * 
     * @return The current state of the instance.
     */
    public final InstanceState currentState() {
        return currentState;
    }

    /**
     * <p>
     * The previous state of the instance.
     * </p>
     * 
     * @return The previous state of the instance.
     */
    public final InstanceState previousState() {
        return previousState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(currentState());
        hashCode = 31 * hashCode + Objects.hashCode(previousState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStateChange)) {
            return false;
        }
        InstanceStateChange other = (InstanceStateChange) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(currentState(), other.currentState())
                && Objects.equals(previousState(), other.previousState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceStateChange").add("InstanceId", instanceId()).add("CurrentState", currentState())
                .add("PreviousState", previousState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "CurrentState":
            return Optional.ofNullable(clazz.cast(currentState()));
        case "PreviousState":
            return Optional.ofNullable(clazz.cast(previousState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStateChange, T> g) {
        return obj -> g.apply((InstanceStateChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceStateChange> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param currentState
         *        The current state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentState(InstanceState currentState);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceState.Builder} avoiding the need
         * to create one manually via {@link InstanceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #currentState(InstanceState)}.
         * 
         * @param currentState
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentState(InstanceState)
         */
        default Builder currentState(Consumer<InstanceState.Builder> currentState) {
            return currentState(InstanceState.builder().applyMutation(currentState).build());
        }

        /**
         * <p>
         * The previous state of the instance.
         * </p>
         * 
         * @param previousState
         *        The previous state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousState(InstanceState previousState);

        /**
         * <p>
         * The previous state of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceState.Builder} avoiding the need
         * to create one manually via {@link InstanceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #previousState(InstanceState)}.
         * 
         * @param previousState
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #previousState(InstanceState)
         */
        default Builder previousState(Consumer<InstanceState.Builder> previousState) {
            return previousState(InstanceState.builder().applyMutation(previousState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private InstanceState currentState;

        private InstanceState previousState;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStateChange model) {
            instanceId(model.instanceId);
            currentState(model.currentState);
            previousState(model.previousState);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final InstanceState.Builder getCurrentState() {
            return currentState != null ? currentState.toBuilder() : null;
        }

        public final void setCurrentState(InstanceState.BuilderImpl currentState) {
            this.currentState = currentState != null ? currentState.build() : null;
        }

        @Override
        public final Builder currentState(InstanceState currentState) {
            this.currentState = currentState;
            return this;
        }

        public final InstanceState.Builder getPreviousState() {
            return previousState != null ? previousState.toBuilder() : null;
        }

        public final void setPreviousState(InstanceState.BuilderImpl previousState) {
            this.previousState = previousState != null ? previousState.build() : null;
        }

        @Override
        public final Builder previousState(InstanceState previousState) {
            this.previousState = previousState;
            return this;
        }

        @Override
        public InstanceStateChange build() {
            return new InstanceStateChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
