/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVpnConnectionDeviceSampleConfigurationRequest extends Ec2Request
        implements
        ToCopyableBuilder<GetVpnConnectionDeviceSampleConfigurationRequest.Builder, GetVpnConnectionDeviceSampleConfigurationRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnConnectionId")
            .getter(getter(GetVpnConnectionDeviceSampleConfigurationRequest::vpnConnectionId))
            .setter(setter(Builder::vpnConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId")
                    .unmarshallLocationName("VpnConnectionId").build()).build();

    private static final SdkField<String> VPN_CONNECTION_DEVICE_TYPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnConnectionDeviceTypeId")
            .getter(getter(GetVpnConnectionDeviceSampleConfigurationRequest::vpnConnectionDeviceTypeId))
            .setter(setter(Builder::vpnConnectionDeviceTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionDeviceTypeId")
                    .unmarshallLocationName("VpnConnectionDeviceTypeId").build()).build();

    private static final SdkField<String> INTERNET_KEY_EXCHANGE_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InternetKeyExchangeVersion")
            .getter(getter(GetVpnConnectionDeviceSampleConfigurationRequest::internetKeyExchangeVersion))
            .setter(setter(Builder::internetKeyExchangeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetKeyExchangeVersion")
                    .unmarshallLocationName("InternetKeyExchangeVersion").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(GetVpnConnectionDeviceSampleConfigurationRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD,
            VPN_CONNECTION_DEVICE_TYPE_ID_FIELD, INTERNET_KEY_EXCHANGE_VERSION_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("VpnConnectionId", VPN_CONNECTION_ID_FIELD);
                    put("VpnConnectionDeviceTypeId", VPN_CONNECTION_DEVICE_TYPE_ID_FIELD);
                    put("InternetKeyExchangeVersion", INTERNET_KEY_EXCHANGE_VERSION_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String vpnConnectionId;

    private final String vpnConnectionDeviceTypeId;

    private final String internetKeyExchangeVersion;

    private final Boolean dryRun;

    private GetVpnConnectionDeviceSampleConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnConnectionDeviceTypeId = builder.vpnConnectionDeviceTypeId;
        this.internetKeyExchangeVersion = builder.internetKeyExchangeVersion;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The <code>VpnConnectionId</code> specifies the Site-to-Site VPN connection used for the sample configuration.
     * </p>
     * 
     * @return The <code>VpnConnectionId</code> specifies the Site-to-Site VPN connection used for the sample
     *         configuration.
     */
    public final String vpnConnectionId() {
        return vpnConnectionId;
    }

    /**
     * <p>
     * Device identifier provided by the <code>GetVpnConnectionDeviceTypes</code> API.
     * </p>
     * 
     * @return Device identifier provided by the <code>GetVpnConnectionDeviceTypes</code> API.
     */
    public final String vpnConnectionDeviceTypeId() {
        return vpnConnectionDeviceTypeId;
    }

    /**
     * <p>
     * The IKE version to be used in the sample configuration file for your customer gateway device. You can specify one
     * of the following versions: <code>ikev1</code> or <code>ikev2</code>.
     * </p>
     * 
     * @return The IKE version to be used in the sample configuration file for your customer gateway device. You can
     *         specify one of the following versions: <code>ikev1</code> or <code>ikev2</code>.
     */
    public final String internetKeyExchangeVersion() {
        return internetKeyExchangeVersion;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionDeviceTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(internetKeyExchangeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVpnConnectionDeviceSampleConfigurationRequest)) {
            return false;
        }
        GetVpnConnectionDeviceSampleConfigurationRequest other = (GetVpnConnectionDeviceSampleConfigurationRequest) obj;
        return Objects.equals(vpnConnectionId(), other.vpnConnectionId())
                && Objects.equals(vpnConnectionDeviceTypeId(), other.vpnConnectionDeviceTypeId())
                && Objects.equals(internetKeyExchangeVersion(), other.internetKeyExchangeVersion())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVpnConnectionDeviceSampleConfigurationRequest").add("VpnConnectionId", vpnConnectionId())
                .add("VpnConnectionDeviceTypeId", vpnConnectionDeviceTypeId())
                .add("InternetKeyExchangeVersion", internetKeyExchangeVersion()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnectionId":
            return Optional.ofNullable(clazz.cast(vpnConnectionId()));
        case "VpnConnectionDeviceTypeId":
            return Optional.ofNullable(clazz.cast(vpnConnectionDeviceTypeId()));
        case "InternetKeyExchangeVersion":
            return Optional.ofNullable(clazz.cast(internetKeyExchangeVersion()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetVpnConnectionDeviceSampleConfigurationRequest, T> g) {
        return obj -> g.apply((GetVpnConnectionDeviceSampleConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVpnConnectionDeviceSampleConfigurationRequest> {
        /**
         * <p>
         * The <code>VpnConnectionId</code> specifies the Site-to-Site VPN connection used for the sample configuration.
         * </p>
         * 
         * @param vpnConnectionId
         *        The <code>VpnConnectionId</code> specifies the Site-to-Site VPN connection used for the sample
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        /**
         * <p>
         * Device identifier provided by the <code>GetVpnConnectionDeviceTypes</code> API.
         * </p>
         * 
         * @param vpnConnectionDeviceTypeId
         *        Device identifier provided by the <code>GetVpnConnectionDeviceTypes</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionDeviceTypeId(String vpnConnectionDeviceTypeId);

        /**
         * <p>
         * The IKE version to be used in the sample configuration file for your customer gateway device. You can specify
         * one of the following versions: <code>ikev1</code> or <code>ikev2</code>.
         * </p>
         * 
         * @param internetKeyExchangeVersion
         *        The IKE version to be used in the sample configuration file for your customer gateway device. You can
         *        specify one of the following versions: <code>ikev1</code> or <code>ikev2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetKeyExchangeVersion(String internetKeyExchangeVersion);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String vpnConnectionId;

        private String vpnConnectionDeviceTypeId;

        private String internetKeyExchangeVersion;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVpnConnectionDeviceSampleConfigurationRequest model) {
            super(model);
            vpnConnectionId(model.vpnConnectionId);
            vpnConnectionDeviceTypeId(model.vpnConnectionDeviceTypeId);
            internetKeyExchangeVersion(model.internetKeyExchangeVersion);
            dryRun(model.dryRun);
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getVpnConnectionDeviceTypeId() {
            return vpnConnectionDeviceTypeId;
        }

        public final void setVpnConnectionDeviceTypeId(String vpnConnectionDeviceTypeId) {
            this.vpnConnectionDeviceTypeId = vpnConnectionDeviceTypeId;
        }

        @Override
        public final Builder vpnConnectionDeviceTypeId(String vpnConnectionDeviceTypeId) {
            this.vpnConnectionDeviceTypeId = vpnConnectionDeviceTypeId;
            return this;
        }

        public final String getInternetKeyExchangeVersion() {
            return internetKeyExchangeVersion;
        }

        public final void setInternetKeyExchangeVersion(String internetKeyExchangeVersion) {
            this.internetKeyExchangeVersion = internetKeyExchangeVersion;
        }

        @Override
        public final Builder internetKeyExchangeVersion(String internetKeyExchangeVersion) {
            this.internetKeyExchangeVersion = internetKeyExchangeVersion;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetVpnConnectionDeviceSampleConfigurationRequest build() {
            return new GetVpnConnectionDeviceSampleConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
