/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClientVpnEndpointsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeClientVpnEndpointsResponse.Builder, DescribeClientVpnEndpointsResponse> {
    private static final SdkField<List<ClientVpnEndpoint>> CLIENT_VPN_ENDPOINTS_FIELD = SdkField
            .<List<ClientVpnEndpoint>> builder(MarshallingType.LIST)
            .memberName("ClientVpnEndpoints")
            .getter(getter(DescribeClientVpnEndpointsResponse::clientVpnEndpoints))
            .setter(setter(Builder::clientVpnEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpoint")
                    .unmarshallLocationName("clientVpnEndpoint").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ClientVpnEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClientVpnEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeClientVpnEndpointsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClientVpnEndpoint", CLIENT_VPN_ENDPOINTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<ClientVpnEndpoint> clientVpnEndpoints;

    private final String nextToken;

    private DescribeClientVpnEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpoints = builder.clientVpnEndpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientVpnEndpoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientVpnEndpoints() {
        return clientVpnEndpoints != null && !(clientVpnEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Client VPN endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientVpnEndpoints} method.
     * </p>
     * 
     * @return Information about the Client VPN endpoints.
     */
    public final List<ClientVpnEndpoint> clientVpnEndpoints() {
        return clientVpnEndpoints;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClientVpnEndpoints() ? clientVpnEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientVpnEndpointsResponse)) {
            return false;
        }
        DescribeClientVpnEndpointsResponse other = (DescribeClientVpnEndpointsResponse) obj;
        return hasClientVpnEndpoints() == other.hasClientVpnEndpoints()
                && Objects.equals(clientVpnEndpoints(), other.clientVpnEndpoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClientVpnEndpointsResponse")
                .add("ClientVpnEndpoints", hasClientVpnEndpoints() ? clientVpnEndpoints() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpoints":
            return Optional.ofNullable(clazz.cast(clientVpnEndpoints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientVpnEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeClientVpnEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClientVpnEndpointsResponse> {
        /**
         * <p>
         * Information about the Client VPN endpoints.
         * </p>
         * 
         * @param clientVpnEndpoints
         *        Information about the Client VPN endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpoints(Collection<ClientVpnEndpoint> clientVpnEndpoints);

        /**
         * <p>
         * Information about the Client VPN endpoints.
         * </p>
         * 
         * @param clientVpnEndpoints
         *        Information about the Client VPN endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpoints(ClientVpnEndpoint... clientVpnEndpoints);

        /**
         * <p>
         * Information about the Client VPN endpoints.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint.Builder#build()} is called immediately and
         * its result is passed to {@link #clientVpnEndpoints(List<ClientVpnEndpoint>)}.
         * 
         * @param clientVpnEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientVpnEndpoints(java.util.Collection<ClientVpnEndpoint>)
         */
        Builder clientVpnEndpoints(Consumer<ClientVpnEndpoint.Builder>... clientVpnEndpoints);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ClientVpnEndpoint> clientVpnEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientVpnEndpointsResponse model) {
            super(model);
            clientVpnEndpoints(model.clientVpnEndpoints);
            nextToken(model.nextToken);
        }

        public final List<ClientVpnEndpoint.Builder> getClientVpnEndpoints() {
            List<ClientVpnEndpoint.Builder> result = EndpointSetCopier.copyToBuilder(this.clientVpnEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientVpnEndpoints(Collection<ClientVpnEndpoint.BuilderImpl> clientVpnEndpoints) {
            this.clientVpnEndpoints = EndpointSetCopier.copyFromBuilder(clientVpnEndpoints);
        }

        @Override
        public final Builder clientVpnEndpoints(Collection<ClientVpnEndpoint> clientVpnEndpoints) {
            this.clientVpnEndpoints = EndpointSetCopier.copy(clientVpnEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpnEndpoints(ClientVpnEndpoint... clientVpnEndpoints) {
            clientVpnEndpoints(Arrays.asList(clientVpnEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpnEndpoints(Consumer<ClientVpnEndpoint.Builder>... clientVpnEndpoints) {
            clientVpnEndpoints(Stream.of(clientVpnEndpoints).map(c -> ClientVpnEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeClientVpnEndpointsResponse build() {
            return new DescribeClientVpnEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
