/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelImportTaskRequest extends Ec2Request implements
        ToCopyableBuilder<CancelImportTaskRequest.Builder, CancelImportTaskRequest> {
    private static final SdkField<String> CANCEL_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CancelReason")
            .getter(getter(CancelImportTaskRequest::cancelReason))
            .setter(setter(Builder::cancelReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelReason")
                    .unmarshallLocationName("CancelReason").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CancelImportTaskRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImportTaskId")
            .getter(getter(CancelImportTaskRequest::importTaskId))
            .setter(setter(Builder::importTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTaskId")
                    .unmarshallLocationName("ImportTaskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCEL_REASON_FIELD,
            DRY_RUN_FIELD, IMPORT_TASK_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CancelReason", CANCEL_REASON_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("ImportTaskId", IMPORT_TASK_ID_FIELD);
                }
            });

    private final String cancelReason;

    private final Boolean dryRun;

    private final String importTaskId;

    private CancelImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.cancelReason = builder.cancelReason;
        this.dryRun = builder.dryRun;
        this.importTaskId = builder.importTaskId;
    }

    /**
     * <p>
     * The reason for canceling the task.
     * </p>
     * 
     * @return The reason for canceling the task.
     */
    public final String cancelReason() {
        return cancelReason;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the import image or import snapshot task to be canceled.
     * </p>
     * 
     * @return The ID of the import image or import snapshot task to be canceled.
     */
    public final String importTaskId() {
        return importTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cancelReason());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskRequest)) {
            return false;
        }
        CancelImportTaskRequest other = (CancelImportTaskRequest) obj;
        return Objects.equals(cancelReason(), other.cancelReason()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(importTaskId(), other.importTaskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelImportTaskRequest").add("CancelReason", cancelReason()).add("DryRun", dryRun())
                .add("ImportTaskId", importTaskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CancelReason":
            return Optional.ofNullable(clazz.cast(cancelReason()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ImportTaskId":
            return Optional.ofNullable(clazz.cast(importTaskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CancelImportTaskRequest, T> g) {
        return obj -> g.apply((CancelImportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CancelImportTaskRequest> {
        /**
         * <p>
         * The reason for canceling the task.
         * </p>
         * 
         * @param cancelReason
         *        The reason for canceling the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelReason(String cancelReason);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the import image or import snapshot task to be canceled.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the import image or import snapshot task to be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cancelReason;

        private Boolean dryRun;

        private String importTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskRequest model) {
            super(model);
            cancelReason(model.cancelReason);
            dryRun(model.dryRun);
            importTaskId(model.importTaskId);
        }

        public final String getCancelReason() {
            return cancelReason;
        }

        public final void setCancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
        }

        @Override
        public final Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelImportTaskRequest build() {
            return new CancelImportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
