/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an potential intermediate component of a feasible path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlternatePathHint implements SdkPojo, Serializable,
        ToCopyableBuilder<AlternatePathHint.Builder, AlternatePathHint> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ComponentId")
            .getter(getter(AlternatePathHint::componentId))
            .setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId")
                    .unmarshallLocationName("componentId").build()).build();

    private static final SdkField<String> COMPONENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ComponentArn")
            .getter(getter(AlternatePathHint::componentArn))
            .setter(setter(Builder::componentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentArn")
                    .unmarshallLocationName("componentArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD,
            COMPONENT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ComponentId", COMPONENT_ID_FIELD);
                    put("ComponentArn", COMPONENT_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String componentId;

    private final String componentArn;

    private AlternatePathHint(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.componentArn = builder.componentArn;
    }

    /**
     * <p>
     * The ID of the component.
     * </p>
     * 
     * @return The ID of the component.
     */
    public final String componentId() {
        return componentId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the component.
     */
    public final String componentArn() {
        return componentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentId());
        hashCode = 31 * hashCode + Objects.hashCode(componentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlternatePathHint)) {
            return false;
        }
        AlternatePathHint other = (AlternatePathHint) obj;
        return Objects.equals(componentId(), other.componentId()) && Objects.equals(componentArn(), other.componentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlternatePathHint").add("ComponentId", componentId()).add("ComponentArn", componentArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "ComponentArn":
            return Optional.ofNullable(clazz.cast(componentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AlternatePathHint, T> g) {
        return obj -> g.apply((AlternatePathHint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlternatePathHint> {
        /**
         * <p>
         * The ID of the component.
         * </p>
         * 
         * @param componentId
         *        The ID of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(String componentId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the component.
         * </p>
         * 
         * @param componentArn
         *        The Amazon Resource Name (ARN) of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentArn(String componentArn);
    }

    static final class BuilderImpl implements Builder {
        private String componentId;

        private String componentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AlternatePathHint model) {
            componentId(model.componentId);
            componentArn(model.componentArn);
        }

        public final String getComponentId() {
            return componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getComponentArn() {
            return componentArn;
        }

        public final void setComponentArn(String componentArn) {
            this.componentArn = componentArn;
        }

        @Override
        public final Builder componentArn(String componentArn) {
            this.componentArn = componentArn;
            return this;
        }

        @Override
        public AlternatePathHint build() {
            return new AlternatePathHint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
