/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.NeuronDeviceCoreInfo;
import software.amazon.awssdk.services.ec2.model.NeuronDeviceMemoryInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NeuronDeviceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NeuronDeviceInfo> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(NeuronDeviceInfo.getter(NeuronDeviceInfo::count)).setter(NeuronDeviceInfo.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("count").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(NeuronDeviceInfo.getter(NeuronDeviceInfo::name)).setter(NeuronDeviceInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<NeuronDeviceCoreInfo> CORE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CoreInfo").getter(NeuronDeviceInfo.getter(NeuronDeviceInfo::coreInfo)).setter(NeuronDeviceInfo.setter(Builder::coreInfo)).constructor(NeuronDeviceCoreInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreInfo").unmarshallLocationName("coreInfo").build()}).build();
    private static final SdkField<NeuronDeviceMemoryInfo> MEMORY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryInfo").getter(NeuronDeviceInfo.getter(NeuronDeviceInfo::memoryInfo)).setter(NeuronDeviceInfo.setter(Builder::memoryInfo)).constructor(NeuronDeviceMemoryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInfo").unmarshallLocationName("memoryInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, NAME_FIELD, CORE_INFO_FIELD, MEMORY_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer count;
    private final String name;
    private final NeuronDeviceCoreInfo coreInfo;
    private final NeuronDeviceMemoryInfo memoryInfo;

    private NeuronDeviceInfo(BuilderImpl builder) {
        this.count = builder.count;
        this.name = builder.name;
        this.coreInfo = builder.coreInfo;
        this.memoryInfo = builder.memoryInfo;
    }

    public final Integer count() {
        return this.count;
    }

    public final String name() {
        return this.name;
    }

    public final NeuronDeviceCoreInfo coreInfo() {
        return this.coreInfo;
    }

    public final NeuronDeviceMemoryInfo memoryInfo() {
        return this.memoryInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeuronDeviceInfo)) {
            return false;
        }
        NeuronDeviceInfo other = (NeuronDeviceInfo)obj;
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.coreInfo(), other.coreInfo()) && Objects.equals(this.memoryInfo(), other.memoryInfo());
    }

    public final String toString() {
        return ToString.builder((String)"NeuronDeviceInfo").add("Count", (Object)this.count()).add("Name", (Object)this.name()).add("CoreInfo", (Object)this.coreInfo()).add("MemoryInfo", (Object)this.memoryInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CoreInfo": {
                return Optional.ofNullable(clazz.cast(this.coreInfo()));
            }
            case "MemoryInfo": {
                return Optional.ofNullable(clazz.cast(this.memoryInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NeuronDeviceInfo, T> g) {
        return obj -> g.apply((NeuronDeviceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer count;
        private String name;
        private NeuronDeviceCoreInfo coreInfo;
        private NeuronDeviceMemoryInfo memoryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(NeuronDeviceInfo model) {
            this.count(model.count);
            this.name(model.name);
            this.coreInfo(model.coreInfo);
            this.memoryInfo(model.memoryInfo);
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NeuronDeviceCoreInfo.Builder getCoreInfo() {
            return this.coreInfo != null ? this.coreInfo.toBuilder() : null;
        }

        public final void setCoreInfo(NeuronDeviceCoreInfo.BuilderImpl coreInfo) {
            this.coreInfo = coreInfo != null ? coreInfo.build() : null;
        }

        @Override
        public final Builder coreInfo(NeuronDeviceCoreInfo coreInfo) {
            this.coreInfo = coreInfo;
            return this;
        }

        public final NeuronDeviceMemoryInfo.Builder getMemoryInfo() {
            return this.memoryInfo != null ? this.memoryInfo.toBuilder() : null;
        }

        public final void setMemoryInfo(NeuronDeviceMemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        @Override
        public final Builder memoryInfo(NeuronDeviceMemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        public NeuronDeviceInfo build() {
            return new NeuronDeviceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NeuronDeviceInfo> {
        public Builder count(Integer var1);

        public Builder name(String var1);

        public Builder coreInfo(NeuronDeviceCoreInfo var1);

        default public Builder coreInfo(Consumer<NeuronDeviceCoreInfo.Builder> coreInfo) {
            return this.coreInfo((NeuronDeviceCoreInfo)((NeuronDeviceCoreInfo.Builder)NeuronDeviceCoreInfo.builder().applyMutation(coreInfo)).build());
        }

        public Builder memoryInfo(NeuronDeviceMemoryInfo var1);

        default public Builder memoryInfo(Consumer<NeuronDeviceMemoryInfo.Builder> memoryInfo) {
            return this.memoryInfo((NeuronDeviceMemoryInfo)((NeuronDeviceMemoryInfo.Builder)NeuronDeviceMemoryInfo.builder().applyMutation(memoryInfo)).build());
        }
    }
}

