/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class TransitGatewayPolicyTableAssociationListCopier {
    static List<TransitGatewayPolicyTableAssociation> copy(
            Collection<? extends TransitGatewayPolicyTableAssociation> transitGatewayPolicyTableAssociationListParam) {
        List<TransitGatewayPolicyTableAssociation> list;
        if (transitGatewayPolicyTableAssociationListParam == null
                || transitGatewayPolicyTableAssociationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TransitGatewayPolicyTableAssociation> modifiableList = new ArrayList<>();
            transitGatewayPolicyTableAssociationListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TransitGatewayPolicyTableAssociation> copyFromBuilder(
            Collection<? extends TransitGatewayPolicyTableAssociation.Builder> transitGatewayPolicyTableAssociationListParam) {
        List<TransitGatewayPolicyTableAssociation> list;
        if (transitGatewayPolicyTableAssociationListParam == null
                || transitGatewayPolicyTableAssociationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TransitGatewayPolicyTableAssociation> modifiableList = new ArrayList<>();
            transitGatewayPolicyTableAssociationListParam.forEach(entry -> {
                TransitGatewayPolicyTableAssociation member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TransitGatewayPolicyTableAssociation.Builder> copyToBuilder(
            Collection<? extends TransitGatewayPolicyTableAssociation> transitGatewayPolicyTableAssociationListParam) {
        List<TransitGatewayPolicyTableAssociation.Builder> list;
        if (transitGatewayPolicyTableAssociationListParam == null
                || transitGatewayPolicyTableAssociationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TransitGatewayPolicyTableAssociation.Builder> modifiableList = new ArrayList<>();
            transitGatewayPolicyTableAssociationListParam.forEach(entry -> {
                TransitGatewayPolicyTableAssociation.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
