/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataAccessStatus {
    DISABLED("Disabled"),
    DISABLING("Disabling"),
    ENABLED("Enabled"),
    ENABLING("Enabling"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataAccessStatus> VALUE_MAP;
    private final String value;

    private DataAccessStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataAccessStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataAccessStatus> knownValues() {
        EnumSet<DataAccessStatus> knownValues = EnumSet.allOf(DataAccessStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataAccessStatus.class, DataAccessStatus::toString);
    }
}

