/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OfferingTransaction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OfferingTransaction> {
    private static final SdkField<OfferingStatus> OFFERING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("offeringStatus").getter(OfferingTransaction.getter(OfferingTransaction::offeringStatus)).setter(OfferingTransaction.setter(Builder::offeringStatus)).constructor(OfferingStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringStatus").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionId").getter(OfferingTransaction.getter(OfferingTransaction::transactionId)).setter(OfferingTransaction.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()}).build();
    private static final SdkField<String> OFFERING_PROMOTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offeringPromotionId").getter(OfferingTransaction.getter(OfferingTransaction::offeringPromotionId)).setter(OfferingTransaction.setter(Builder::offeringPromotionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringPromotionId").build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdOn").getter(OfferingTransaction.getter(OfferingTransaction::createdOn)).setter(OfferingTransaction.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdOn").build()}).build();
    private static final SdkField<MonetaryAmount> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cost").getter(OfferingTransaction.getter(OfferingTransaction::cost)).setter(OfferingTransaction.setter(Builder::cost)).constructor(MonetaryAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_STATUS_FIELD, TRANSACTION_ID_FIELD, OFFERING_PROMOTION_ID_FIELD, CREATED_ON_FIELD, COST_FIELD));
    private static final long serialVersionUID = 1L;
    private final OfferingStatus offeringStatus;
    private final String transactionId;
    private final String offeringPromotionId;
    private final Instant createdOn;
    private final MonetaryAmount cost;

    private OfferingTransaction(BuilderImpl builder) {
        this.offeringStatus = builder.offeringStatus;
        this.transactionId = builder.transactionId;
        this.offeringPromotionId = builder.offeringPromotionId;
        this.createdOn = builder.createdOn;
        this.cost = builder.cost;
    }

    public final OfferingStatus offeringStatus() {
        return this.offeringStatus;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final String offeringPromotionId() {
        return this.offeringPromotionId;
    }

    public final Instant createdOn() {
        return this.createdOn;
    }

    public final MonetaryAmount cost() {
        return this.cost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringPromotionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingTransaction)) {
            return false;
        }
        OfferingTransaction other = (OfferingTransaction)obj;
        return Objects.equals(this.offeringStatus(), other.offeringStatus()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.offeringPromotionId(), other.offeringPromotionId()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.cost(), other.cost());
    }

    public final String toString() {
        return ToString.builder((String)"OfferingTransaction").add("OfferingStatus", (Object)this.offeringStatus()).add("TransactionId", (Object)this.transactionId()).add("OfferingPromotionId", (Object)this.offeringPromotionId()).add("CreatedOn", (Object)this.createdOn()).add("Cost", (Object)this.cost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringStatus": {
                return Optional.ofNullable(clazz.cast(this.offeringStatus()));
            }
            case "transactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "offeringPromotionId": {
                return Optional.ofNullable(clazz.cast(this.offeringPromotionId()));
            }
            case "createdOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfferingTransaction, T> g) {
        return obj -> g.apply((OfferingTransaction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OfferingStatus offeringStatus;
        private String transactionId;
        private String offeringPromotionId;
        private Instant createdOn;
        private MonetaryAmount cost;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingTransaction model) {
            this.offeringStatus(model.offeringStatus);
            this.transactionId(model.transactionId);
            this.offeringPromotionId(model.offeringPromotionId);
            this.createdOn(model.createdOn);
            this.cost(model.cost);
        }

        public final OfferingStatus.Builder getOfferingStatus() {
            return this.offeringStatus != null ? this.offeringStatus.toBuilder() : null;
        }

        public final void setOfferingStatus(OfferingStatus.BuilderImpl offeringStatus) {
            this.offeringStatus = offeringStatus != null ? offeringStatus.build() : null;
        }

        @Override
        public final Builder offeringStatus(OfferingStatus offeringStatus) {
            this.offeringStatus = offeringStatus;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getOfferingPromotionId() {
            return this.offeringPromotionId;
        }

        public final void setOfferingPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
        }

        @Override
        public final Builder offeringPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
            return this;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final MonetaryAmount.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        public final void setCost(MonetaryAmount.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public OfferingTransaction build() {
            return new OfferingTransaction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OfferingTransaction> {
        public Builder offeringStatus(OfferingStatus var1);

        default public Builder offeringStatus(Consumer<OfferingStatus.Builder> offeringStatus) {
            return this.offeringStatus((OfferingStatus)((OfferingStatus.Builder)OfferingStatus.builder().applyMutation(offeringStatus)).build());
        }

        public Builder transactionId(String var1);

        public Builder offeringPromotionId(String var1);

        public Builder createdOn(Instant var1);

        public Builder cost(MonetaryAmount var1);

        default public Builder cost(Consumer<MonetaryAmount.Builder> cost) {
            return this.cost((MonetaryAmount)((MonetaryAmount.Builder)MonetaryAmount.builder().applyMutation(cost)).build());
        }
    }
}

