/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.AnalysisSummary;
import software.amazon.awssdk.services.costexplorer.model.ListCommitmentPurchaseAnalysesRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCommitmentPurchaseAnalysesResponse;

public class ListCommitmentPurchaseAnalysesPublisher
implements SdkPublisher<ListCommitmentPurchaseAnalysesResponse> {
    private final CostExplorerAsyncClient client;
    private final ListCommitmentPurchaseAnalysesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCommitmentPurchaseAnalysesPublisher(CostExplorerAsyncClient client, ListCommitmentPurchaseAnalysesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCommitmentPurchaseAnalysesPublisher(CostExplorerAsyncClient client, ListCommitmentPurchaseAnalysesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCommitmentPurchaseAnalysesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCommitmentPurchaseAnalysesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnalysisSummary> analysisSummaryList() {
        return this.flatMapIterable(response -> response.analysisSummaryList());
    }

    private class ListCommitmentPurchaseAnalysesResponseFetcher
    implements AsyncPageFetcher<ListCommitmentPurchaseAnalysesResponse> {
        private ListCommitmentPurchaseAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(ListCommitmentPurchaseAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListCommitmentPurchaseAnalysesResponse> nextPage(ListCommitmentPurchaseAnalysesResponse previousPage) {
            if (previousPage == null) {
                return ListCommitmentPurchaseAnalysesPublisher.this.client.listCommitmentPurchaseAnalyses(ListCommitmentPurchaseAnalysesPublisher.this.firstRequest);
            }
            return ListCommitmentPurchaseAnalysesPublisher.this.client.listCommitmentPurchaseAnalyses((ListCommitmentPurchaseAnalysesRequest)((Object)ListCommitmentPurchaseAnalysesPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

