/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation;

public class GetRightsizingRecommendationIterable
implements SdkIterable<GetRightsizingRecommendationResponse> {
    private final CostExplorerClient client;
    private final GetRightsizingRecommendationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetRightsizingRecommendationIterable(CostExplorerClient client, GetRightsizingRecommendationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetRightsizingRecommendationResponseFetcher();
    }

    public Iterator<GetRightsizingRecommendationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RightsizingRecommendation> rightsizingRecommendations() {
        Function<GetRightsizingRecommendationResponse, Iterator> getIterator = response -> {
            if (response != null && response.rightsizingRecommendations() != null) {
                return response.rightsizingRecommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetRightsizingRecommendationResponseFetcher
    implements SyncPageFetcher<GetRightsizingRecommendationResponse> {
        private GetRightsizingRecommendationResponseFetcher() {
        }

        public boolean hasNextPage(GetRightsizingRecommendationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetRightsizingRecommendationResponse nextPage(GetRightsizingRecommendationResponse previousPage) {
            if (previousPage == null) {
                return GetRightsizingRecommendationIterable.this.client.getRightsizingRecommendation(GetRightsizingRecommendationIterable.this.firstRequest);
            }
            return GetRightsizingRecommendationIterable.this.client.getRightsizingRecommendation((GetRightsizingRecommendationRequest)((Object)GetRightsizingRecommendationIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

