/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostAndUsageComparison;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageComparisonsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageComparisonsResponse;

public class GetCostAndUsageComparisonsPublisher
implements SdkPublisher<GetCostAndUsageComparisonsResponse> {
    private final CostExplorerAsyncClient client;
    private final GetCostAndUsageComparisonsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCostAndUsageComparisonsPublisher(CostExplorerAsyncClient client, GetCostAndUsageComparisonsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCostAndUsageComparisonsPublisher(CostExplorerAsyncClient client, GetCostAndUsageComparisonsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCostAndUsageComparisonsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCostAndUsageComparisonsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CostAndUsageComparison> costAndUsageComparisons() {
        return this.flatMapIterable(response -> response.costAndUsageComparisons());
    }

    private class GetCostAndUsageComparisonsResponseFetcher
    implements AsyncPageFetcher<GetCostAndUsageComparisonsResponse> {
        private GetCostAndUsageComparisonsResponseFetcher() {
        }

        public boolean hasNextPage(GetCostAndUsageComparisonsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetCostAndUsageComparisonsResponse> nextPage(GetCostAndUsageComparisonsResponse previousPage) {
            if (previousPage == null) {
                return GetCostAndUsageComparisonsPublisher.this.client.getCostAndUsageComparisons(GetCostAndUsageComparisonsPublisher.this.firstRequest);
            }
            return GetCostAndUsageComparisonsPublisher.this.client.getCostAndUsageComparisons((GetCostAndUsageComparisonsRequest)((Object)GetCostAndUsageComparisonsPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

