/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.RuleExecution;
import software.amazon.awssdk.services.codepipeline.model.RuleRevision;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleState> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(RuleState.getter(RuleState::ruleName)).setter(RuleState.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()}).build();
    private static final SdkField<RuleRevision> CURRENT_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentRevision").getter(RuleState.getter(RuleState::currentRevision)).setter(RuleState.setter(Builder::currentRevision)).constructor(RuleRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevision").build()}).build();
    private static final SdkField<RuleExecution> LATEST_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestExecution").getter(RuleState.getter(RuleState::latestExecution)).setter(RuleState.setter(Builder::latestExecution)).constructor(RuleExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()}).build();
    private static final SdkField<String> ENTITY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityUrl").getter(RuleState.getter(RuleState::entityUrl)).setter(RuleState.setter(Builder::entityUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityUrl").build()}).build();
    private static final SdkField<String> REVISION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionUrl").getter(RuleState.getter(RuleState::revisionUrl)).setter(RuleState.setter(Builder::revisionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, CURRENT_REVISION_FIELD, LATEST_EXECUTION_FIELD, ENTITY_URL_FIELD, REVISION_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final RuleRevision currentRevision;
    private final RuleExecution latestExecution;
    private final String entityUrl;
    private final String revisionUrl;

    private RuleState(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.currentRevision = builder.currentRevision;
        this.latestExecution = builder.latestExecution;
        this.entityUrl = builder.entityUrl;
        this.revisionUrl = builder.revisionUrl;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final RuleRevision currentRevision() {
        return this.currentRevision;
    }

    public final RuleExecution latestExecution() {
        return this.latestExecution;
    }

    public final String entityUrl() {
        return this.entityUrl;
    }

    public final String revisionUrl() {
        return this.revisionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleState)) {
            return false;
        }
        RuleState other = (RuleState)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.currentRevision(), other.currentRevision()) && Objects.equals(this.latestExecution(), other.latestExecution()) && Objects.equals(this.entityUrl(), other.entityUrl()) && Objects.equals(this.revisionUrl(), other.revisionUrl());
    }

    public final String toString() {
        return ToString.builder((String)"RuleState").add("RuleName", (Object)this.ruleName()).add("CurrentRevision", (Object)this.currentRevision()).add("LatestExecution", (Object)this.latestExecution()).add("EntityUrl", (Object)this.entityUrl()).add("RevisionUrl", (Object)this.revisionUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "currentRevision": {
                return Optional.ofNullable(clazz.cast(this.currentRevision()));
            }
            case "latestExecution": {
                return Optional.ofNullable(clazz.cast(this.latestExecution()));
            }
            case "entityUrl": {
                return Optional.ofNullable(clazz.cast(this.entityUrl()));
            }
            case "revisionUrl": {
                return Optional.ofNullable(clazz.cast(this.revisionUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleState, T> g) {
        return obj -> g.apply((RuleState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private RuleRevision currentRevision;
        private RuleExecution latestExecution;
        private String entityUrl;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleState model) {
            this.ruleName(model.ruleName);
            this.currentRevision(model.currentRevision);
            this.latestExecution(model.latestExecution);
            this.entityUrl(model.entityUrl);
            this.revisionUrl(model.revisionUrl);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final RuleRevision.Builder getCurrentRevision() {
            return this.currentRevision != null ? this.currentRevision.toBuilder() : null;
        }

        public final void setCurrentRevision(RuleRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        @Override
        public final Builder currentRevision(RuleRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final RuleExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(RuleExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(RuleExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final String getEntityUrl() {
            return this.entityUrl;
        }

        public final void setEntityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
        }

        @Override
        public final Builder entityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
            return this;
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public RuleState build() {
            return new RuleState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleState> {
        public Builder ruleName(String var1);

        public Builder currentRevision(RuleRevision var1);

        default public Builder currentRevision(Consumer<RuleRevision.Builder> currentRevision) {
            return this.currentRevision((RuleRevision)((RuleRevision.Builder)RuleRevision.builder().applyMutation(currentRevision)).build());
        }

        public Builder latestExecution(RuleExecution var1);

        default public Builder latestExecution(Consumer<RuleExecution.Builder> latestExecution) {
            return this.latestExecution((RuleExecution)((RuleExecution.Builder)RuleExecution.builder().applyMutation(latestExecution)).build());
        }

        public Builder entityUrl(String var1);

        public Builder revisionUrl(String var1);
    }
}

