/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the configuration information about one metric stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricStreamEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricStreamEntry.Builder, MetricStreamEntry> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(MetricStreamEntry::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(MetricStreamEntry::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateDate").getter(getter(MetricStreamEntry::lastUpdateDate))
            .setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MetricStreamEntry::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FIREHOSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirehoseArn").getter(getter(MetricStreamEntry::firehoseArn)).setter(setter(Builder::firehoseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(MetricStreamEntry::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(MetricStreamEntry::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD, NAME_FIELD, FIREHOSE_ARN_FIELD, STATE_FIELD, OUTPUT_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant creationDate;

    private final Instant lastUpdateDate;

    private final String name;

    private final String firehoseArn;

    private final String state;

    private final String outputFormat;

    private MetricStreamEntry(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.name = builder.name;
        this.firehoseArn = builder.firehoseArn;
        this.state = builder.state;
        this.outputFormat = builder.outputFormat;
    }

    /**
     * <p>
     * The ARN of the metric stream.
     * </p>
     * 
     * @return The ARN of the metric stream.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date that the metric stream was originally created.
     * </p>
     * 
     * @return The date that the metric stream was originally created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date that the configuration of this metric stream was most recently updated.
     * </p>
     * 
     * @return The date that the configuration of this metric stream was most recently updated.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    /**
     * <p>
     * The name of the metric stream.
     * </p>
     * 
     * @return The name of the metric stream.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.
     * </p>
     * 
     * @return The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.
     */
    public final String firehoseArn() {
        return firehoseArn;
    }

    /**
     * <p>
     * The current state of this stream. Valid values are <code>running</code> and <code>stopped</code>.
     * </p>
     * 
     * @return The current state of this stream. Valid values are <code>running</code> and <code>stopped</code>.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The output format of this metric stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>, and
     * <code>opentelemetry0.7</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link MetricStreamOutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The output format of this metric stream. Valid values are <code>json</code>,
     *         <code>opentelemetry1.0</code>, and <code>opentelemetry0.7</code>.
     * @see MetricStreamOutputFormat
     */
    public final MetricStreamOutputFormat outputFormat() {
        return MetricStreamOutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The output format of this metric stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>, and
     * <code>opentelemetry0.7</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link MetricStreamOutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The output format of this metric stream. Valid values are <code>json</code>,
     *         <code>opentelemetry1.0</code>, and <code>opentelemetry0.7</code>.
     * @see MetricStreamOutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(firehoseArn());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStreamEntry)) {
            return false;
        }
        MetricStreamEntry other = (MetricStreamEntry) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate()) && Objects.equals(name(), other.name())
                && Objects.equals(firehoseArn(), other.firehoseArn()) && Objects.equals(state(), other.state())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricStreamEntry").add("Arn", arn()).add("CreationDate", creationDate())
                .add("LastUpdateDate", lastUpdateDate()).add("Name", name()).add("FirehoseArn", firehoseArn())
                .add("State", state()).add("OutputFormat", outputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FirehoseArn":
            return Optional.ofNullable(clazz.cast(firehoseArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastUpdateDate", LAST_UPDATE_DATE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("FirehoseArn", FIREHOSE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricStreamEntry, T> g) {
        return obj -> g.apply((MetricStreamEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricStreamEntry> {
        /**
         * <p>
         * The ARN of the metric stream.
         * </p>
         * 
         * @param arn
         *        The ARN of the metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date that the metric stream was originally created.
         * </p>
         * 
         * @param creationDate
         *        The date that the metric stream was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date that the configuration of this metric stream was most recently updated.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date that the configuration of this metric stream was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);

        /**
         * <p>
         * The name of the metric stream.
         * </p>
         * 
         * @param name
         *        The name of the metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.
         * </p>
         * 
         * @param firehoseArn
         *        The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehoseArn(String firehoseArn);

        /**
         * <p>
         * The current state of this stream. Valid values are <code>running</code> and <code>stopped</code>.
         * </p>
         * 
         * @param state
         *        The current state of this stream. Valid values are <code>running</code> and <code>stopped</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The output format of this metric stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>,
         * and <code>opentelemetry0.7</code>.
         * </p>
         * 
         * @param outputFormat
         *        The output format of this metric stream. Valid values are <code>json</code>,
         *        <code>opentelemetry1.0</code>, and <code>opentelemetry0.7</code>.
         * @see MetricStreamOutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStreamOutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The output format of this metric stream. Valid values are <code>json</code>, <code>opentelemetry1.0</code>,
         * and <code>opentelemetry0.7</code>.
         * </p>
         * 
         * @param outputFormat
         *        The output format of this metric stream. Valid values are <code>json</code>,
         *        <code>opentelemetry1.0</code>, and <code>opentelemetry0.7</code>.
         * @see MetricStreamOutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStreamOutputFormat
         */
        Builder outputFormat(MetricStreamOutputFormat outputFormat);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant creationDate;

        private Instant lastUpdateDate;

        private String name;

        private String firehoseArn;

        private String state;

        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStreamEntry model) {
            arn(model.arn);
            creationDate(model.creationDate);
            lastUpdateDate(model.lastUpdateDate);
            name(model.name);
            firehoseArn(model.firehoseArn);
            state(model.state);
            outputFormat(model.outputFormat);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFirehoseArn() {
            return firehoseArn;
        }

        public final void setFirehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
        }

        @Override
        public final Builder firehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(MetricStreamOutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        @Override
        public MetricStreamEntry build() {
            return new MetricStreamEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
