/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response confirming that the event stream is complete.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvokeWithResponseStreamCompleteEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<InvokeWithResponseStreamCompleteEvent.Builder, InvokeWithResponseStreamCompleteEvent>,
        InvokeWithResponseStreamResponseEvent {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(InvokeWithResponseStreamCompleteEvent::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorDetails").getter(getter(InvokeWithResponseStreamCompleteEvent::errorDetails))
            .setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()).build();

    private static final SdkField<String> LOG_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogResult").getter(getter(InvokeWithResponseStreamCompleteEvent::logResult))
            .setter(setter(Builder::logResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_DETAILS_FIELD, LOG_RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorDetails;

    private final String logResult;

    protected InvokeWithResponseStreamCompleteEvent(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorDetails = builder.errorDetails;
        this.logResult = builder.logResult;
    }

    /**
     * <p>
     * An error code.
     * </p>
     * 
     * @return An error code.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The details of any returned error.
     * </p>
     * 
     * @return The details of any returned error.
     */
    public final String errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * The last 4 KB of the execution log, which is base64-encoded.
     * </p>
     * 
     * @return The last 4 KB of the execution log, which is base64-encoded.
     */
    public final String logResult() {
        return logResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(logResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeWithResponseStreamCompleteEvent)) {
            return false;
        }
        InvokeWithResponseStreamCompleteEvent other = (InvokeWithResponseStreamCompleteEvent) obj;
        return Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(logResult(), other.logResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeWithResponseStreamCompleteEvent").add("ErrorCode", errorCode())
                .add("ErrorDetails", errorDetails()).add("LogResult", logResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "LogResult":
            return Optional.ofNullable(clazz.cast(logResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final InvokeWithResponseStreamCompleteEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeWithResponseStreamCompleteEvent, T> g) {
        return obj -> g.apply((InvokeWithResponseStreamCompleteEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link InvokeWithResponseStreamCompleteEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeWithResponseStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvokeWithResponseStreamCompleteEvent> {
        /**
         * <p>
         * An error code.
         * </p>
         * 
         * @param errorCode
         *        An error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The details of any returned error.
         * </p>
         * 
         * @param errorDetails
         *        The details of any returned error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(String errorDetails);

        /**
         * <p>
         * The last 4 KB of the execution log, which is base64-encoded.
         * </p>
         * 
         * @param logResult
         *        The last 4 KB of the execution log, which is base64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logResult(String logResult);
    }

    protected static class BuilderImpl implements Builder {
        private String errorCode;

        private String errorDetails;

        private String logResult;

        protected BuilderImpl() {
        }

        protected BuilderImpl(InvokeWithResponseStreamCompleteEvent model) {
            errorCode(model.errorCode);
            errorDetails(model.errorDetails);
            logResult(model.logResult);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorDetails() {
            return errorDetails;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getLogResult() {
            return logResult;
        }

        public final void setLogResult(String logResult) {
            this.logResult = logResult;
        }

        @Override
        public final Builder logResult(String logResult) {
            this.logResult = logResult;
            return this;
        }

        @Override
        public InvokeWithResponseStreamCompleteEvent build() {
            return new InvokeWithResponseStreamCompleteEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
