/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImageGenerationConfigurationRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<UpdateImageGenerationConfigurationRequest.Builder, UpdateImageGenerationConfigurationRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(UpdateImageGenerationConfigurationRequest::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(UpdateImageGenerationConfigurationRequest::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<ImageGenerationConfiguration> IMAGE_GENERATION_CONFIGURATION_FIELD = SdkField
            .<ImageGenerationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ImageGenerationConfiguration")
            .getter(getter(UpdateImageGenerationConfigurationRequest::imageGenerationConfiguration))
            .setter(setter(Builder::imageGenerationConfiguration))
            .constructor(ImageGenerationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageGenerationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, IMAGE_GENERATION_CONFIGURATION_FIELD));

    private final String streamName;

    private final String streamARN;

    private final ImageGenerationConfiguration imageGenerationConfiguration;

    private UpdateImageGenerationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.imageGenerationConfiguration = builder.imageGenerationConfiguration;
    }

    /**
     * <p>
     * The name of the stream from which to update the image generation configuration. You must specify either the
     * <code>StreamName</code> or the <code>StreamARN</code>.
     * </p>
     * 
     * @return The name of the stream from which to update the image generation configuration. You must specify either
     *         the <code>StreamName</code> or the <code>StreamARN</code>.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Kinesis video stream from where you want to update the image generation
     * configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Kinesis video stream from where you want to update the image
     *         generation configuration. You must specify either the <code>StreamName</code> or the
     *         <code>StreamARN</code>.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The structure that contains the information required for the KVS images delivery. If the structure is null, the
     * configuration will be deleted from the stream.
     * </p>
     * 
     * @return The structure that contains the information required for the KVS images delivery. If the structure is
     *         null, the configuration will be deleted from the stream.
     */
    public final ImageGenerationConfiguration imageGenerationConfiguration() {
        return imageGenerationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(imageGenerationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageGenerationConfigurationRequest)) {
            return false;
        }
        UpdateImageGenerationConfigurationRequest other = (UpdateImageGenerationConfigurationRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(imageGenerationConfiguration(), other.imageGenerationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImageGenerationConfigurationRequest").add("StreamName", streamName())
                .add("StreamARN", streamARN()).add("ImageGenerationConfiguration", imageGenerationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "ImageGenerationConfiguration":
            return Optional.ofNullable(clazz.cast(imageGenerationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageGenerationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateImageGenerationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateImageGenerationConfigurationRequest> {
        /**
         * <p>
         * The name of the stream from which to update the image generation configuration. You must specify either the
         * <code>StreamName</code> or the <code>StreamARN</code>.
         * </p>
         * 
         * @param streamName
         *        The name of the stream from which to update the image generation configuration. You must specify
         *        either the <code>StreamName</code> or the <code>StreamARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Kinesis video stream from where you want to update the image generation
         * configuration. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the Kinesis video stream from where you want to update the image
         *        generation configuration. You must specify either the <code>StreamName</code> or the
         *        <code>StreamARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The structure that contains the information required for the KVS images delivery. If the structure is null,
         * the configuration will be deleted from the stream.
         * </p>
         * 
         * @param imageGenerationConfiguration
         *        The structure that contains the information required for the KVS images delivery. If the structure is
         *        null, the configuration will be deleted from the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageGenerationConfiguration(ImageGenerationConfiguration imageGenerationConfiguration);

        /**
         * <p>
         * The structure that contains the information required for the KVS images delivery. If the structure is null,
         * the configuration will be deleted from the stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageGenerationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageGenerationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageGenerationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #imageGenerationConfiguration(ImageGenerationConfiguration)}.
         * 
         * @param imageGenerationConfiguration
         *        a consumer that will call methods on {@link ImageGenerationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageGenerationConfiguration(ImageGenerationConfiguration)
         */
        default Builder imageGenerationConfiguration(Consumer<ImageGenerationConfiguration.Builder> imageGenerationConfiguration) {
            return imageGenerationConfiguration(ImageGenerationConfiguration.builder()
                    .applyMutation(imageGenerationConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private ImageGenerationConfiguration imageGenerationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageGenerationConfigurationRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            imageGenerationConfiguration(model.imageGenerationConfiguration);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final ImageGenerationConfiguration.Builder getImageGenerationConfiguration() {
            return imageGenerationConfiguration != null ? imageGenerationConfiguration.toBuilder() : null;
        }

        public final void setImageGenerationConfiguration(ImageGenerationConfiguration.BuilderImpl imageGenerationConfiguration) {
            this.imageGenerationConfiguration = imageGenerationConfiguration != null ? imageGenerationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder imageGenerationConfiguration(ImageGenerationConfiguration imageGenerationConfiguration) {
            this.imageGenerationConfiguration = imageGenerationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImageGenerationConfigurationRequest build() {
            return new UpdateImageGenerationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
