/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object for the <code>CreateBackup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackupResponse extends FSxResponse implements
        ToCopyableBuilder<CreateBackupResponse.Builder, CreateBackupResponse> {
    private static final SdkField<Backup> BACKUP_FIELD = SdkField.<Backup> builder(MarshallingType.SDK_POJO).memberName("Backup")
            .getter(getter(CreateBackupResponse::backup)).setter(setter(Builder::backup)).constructor(Backup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_FIELD));

    private final Backup backup;

    private CreateBackupResponse(BuilderImpl builder) {
        super(builder);
        this.backup = builder.backup;
    }

    /**
     * <p>
     * A description of the backup.
     * </p>
     * 
     * @return A description of the backup.
     */
    public final Backup backup() {
        return backup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupResponse)) {
            return false;
        }
        CreateBackupResponse other = (CreateBackupResponse) obj;
        return Objects.equals(backup(), other.backup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackupResponse").add("Backup", backup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Backup":
            return Optional.ofNullable(clazz.cast(backup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupResponse, T> g) {
        return obj -> g.apply((CreateBackupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackupResponse> {
        /**
         * <p>
         * A description of the backup.
         * </p>
         * 
         * @param backup
         *        A description of the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backup(Backup backup);

        /**
         * <p>
         * A description of the backup.
         * </p>
         * This is a convenience method that creates an instance of the {@link Backup.Builder} avoiding the need to
         * create one manually via {@link Backup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Backup.Builder#build()} is called immediately and its result is
         * passed to {@link #backup(Backup)}.
         * 
         * @param backup
         *        a consumer that will call methods on {@link Backup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backup(Backup)
         */
        default Builder backup(Consumer<Backup.Builder> backup) {
            return backup(Backup.builder().applyMutation(backup).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private Backup backup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupResponse model) {
            super(model);
            backup(model.backup);
        }

        public final Backup.Builder getBackup() {
            return backup != null ? backup.toBuilder() : null;
        }

        public final void setBackup(Backup.BuilderImpl backup) {
            this.backup = backup != null ? backup.build() : null;
        }

        @Override
        public final Builder backup(Backup backup) {
            this.backup = backup;
            return this;
        }

        @Override
        public CreateBackupResponse build() {
            return new CreateBackupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
