/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetViolationDetailsRequest extends FmsRequest implements
        ToCopyableBuilder<GetViolationDetailsRequest.Builder, GetViolationDetailsRequest> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(GetViolationDetailsRequest::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> MEMBER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberAccount").getter(getter(GetViolationDetailsRequest::memberAccount))
            .setter(setter(Builder::memberAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccount").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(GetViolationDetailsRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(GetViolationDetailsRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            MEMBER_ACCOUNT_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));

    private final String policyId;

    private final String memberAccount;

    private final String resourceId;

    private final String resourceType;

    private GetViolationDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.policyId = builder.policyId;
        this.memberAccount = builder.memberAccount;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The ID of the Firewall Manager policy that you want the details for. You can get violation details for the
     * following policy types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DNS Firewall
     * </p>
     * </li>
     * <li>
     * <p>
     * Imported Network Firewall
     * </p>
     * </li>
     * <li>
     * <p>
     * Network Firewall
     * </p>
     * </li>
     * <li>
     * <p>
     * Security group content audit
     * </p>
     * </li>
     * <li>
     * <p>
     * Third-party firewall
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ID of the Firewall Manager policy that you want the details for. You can get violation details for
     *         the following policy types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DNS Firewall
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Imported Network Firewall
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Network Firewall
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Security group content audit
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Third-party firewall
     *         </p>
     *         </li>
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that you want the details for.
     * </p>
     * 
     * @return The Amazon Web Services account ID that you want the details for.
     */
    public final String memberAccount() {
        return memberAccount;
    }

    /**
     * <p>
     * The ID of the resource that has violations.
     * </p>
     * 
     * @return The ID of the resource that has violations.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The resource type. This is in the format shown in the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services Resource Types Reference</a>. Supported resource types are: <code>AWS::EC2::Instance</code>,
     * <code>AWS::EC2::NetworkInterface</code>, <code>AWS::EC2::SecurityGroup</code>,
     * <code>AWS::NetworkFirewall::FirewallPolicy</code>, and <code>AWS::EC2::Subnet</code>.
     * </p>
     * 
     * @return The resource type. This is in the format shown in the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Amazon Web Services Resource Types Reference</a>. Supported resource types are:
     *         <code>AWS::EC2::Instance</code>, <code>AWS::EC2::NetworkInterface</code>,
     *         <code>AWS::EC2::SecurityGroup</code>, <code>AWS::NetworkFirewall::FirewallPolicy</code>, and
     *         <code>AWS::EC2::Subnet</code>.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetViolationDetailsRequest)) {
            return false;
        }
        GetViolationDetailsRequest other = (GetViolationDetailsRequest) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(memberAccount(), other.memberAccount())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetViolationDetailsRequest").add("PolicyId", policyId()).add("MemberAccount", memberAccount())
                .add("ResourceId", resourceId()).add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "MemberAccount":
            return Optional.ofNullable(clazz.cast(memberAccount()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetViolationDetailsRequest, T> g) {
        return obj -> g.apply((GetViolationDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetViolationDetailsRequest> {
        /**
         * <p>
         * The ID of the Firewall Manager policy that you want the details for. You can get violation details for the
         * following policy types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DNS Firewall
         * </p>
         * </li>
         * <li>
         * <p>
         * Imported Network Firewall
         * </p>
         * </li>
         * <li>
         * <p>
         * Network Firewall
         * </p>
         * </li>
         * <li>
         * <p>
         * Security group content audit
         * </p>
         * </li>
         * <li>
         * <p>
         * Third-party firewall
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyId
         *        The ID of the Firewall Manager policy that you want the details for. You can get violation details for
         *        the following policy types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DNS Firewall
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Imported Network Firewall
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Network Firewall
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Security group content audit
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Third-party firewall
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The Amazon Web Services account ID that you want the details for.
         * </p>
         * 
         * @param memberAccount
         *        The Amazon Web Services account ID that you want the details for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccount(String memberAccount);

        /**
         * <p>
         * The ID of the resource that has violations.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource that has violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The resource type. This is in the format shown in the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Amazon Web Services Resource Types Reference</a>. Supported resource types are:
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::NetworkInterface</code>,
         * <code>AWS::EC2::SecurityGroup</code>, <code>AWS::NetworkFirewall::FirewallPolicy</code>, and
         * <code>AWS::EC2::Subnet</code>.
         * </p>
         * 
         * @param resourceType
         *        The resource type. This is in the format shown in the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Amazon Web Services Resource Types Reference</a>. Supported resource types are:
         *        <code>AWS::EC2::Instance</code>, <code>AWS::EC2::NetworkInterface</code>,
         *        <code>AWS::EC2::SecurityGroup</code>, <code>AWS::NetworkFirewall::FirewallPolicy</code>, and
         *        <code>AWS::EC2::Subnet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String policyId;

        private String memberAccount;

        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetViolationDetailsRequest model) {
            super(model);
            policyId(model.policyId);
            memberAccount(model.memberAccount);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getMemberAccount() {
            return memberAccount;
        }

        public final void setMemberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
        }

        @Override
        public final Builder memberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetViolationDetailsRequest build() {
            return new GetViolationDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
