/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyResourcesExistForTagrisRequest extends FirehoseRequest implements
        ToCopyableBuilder<VerifyResourcesExistForTagrisRequest.Builder, VerifyResourcesExistForTagrisRequest> {
    private static final SdkField<List<TagrisSweepListItem>> TAGRIS_SWEEP_LIST_FIELD = SdkField
            .<List<TagrisSweepListItem>> builder(MarshallingType.LIST)
            .memberName("TagrisSweepList")
            .getter(getter(VerifyResourcesExistForTagrisRequest::tagrisSweepList))
            .setter(setter(Builder::tagrisSweepList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisSweepList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagrisSweepListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagrisSweepListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGRIS_SWEEP_LIST_FIELD));

    private final List<TagrisSweepListItem> tagrisSweepList;

    private VerifyResourcesExistForTagrisRequest(BuilderImpl builder) {
        super(builder);
        this.tagrisSweepList = builder.tagrisSweepList;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagrisSweepList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagrisSweepList() {
        return tagrisSweepList != null && !(tagrisSweepList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagrisSweepList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagrisSweepList} method.
     * </p>
     * 
     * @return The value of the TagrisSweepList property for this object.
     */
    public final List<TagrisSweepListItem> tagrisSweepList() {
        return tagrisSweepList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTagrisSweepList() ? tagrisSweepList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyResourcesExistForTagrisRequest)) {
            return false;
        }
        VerifyResourcesExistForTagrisRequest other = (VerifyResourcesExistForTagrisRequest) obj;
        return hasTagrisSweepList() == other.hasTagrisSweepList() && Objects.equals(tagrisSweepList(), other.tagrisSweepList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyResourcesExistForTagrisRequest")
                .add("TagrisSweepList", hasTagrisSweepList() ? tagrisSweepList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagrisSweepList":
            return Optional.ofNullable(clazz.cast(tagrisSweepList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyResourcesExistForTagrisRequest, T> g) {
        return obj -> g.apply((VerifyResourcesExistForTagrisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifyResourcesExistForTagrisRequest> {
        /**
         * Sets the value of the TagrisSweepList property for this object.
         *
         * @param tagrisSweepList
         *        The new value for the TagrisSweepList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagrisSweepList(Collection<TagrisSweepListItem> tagrisSweepList);

        /**
         * Sets the value of the TagrisSweepList property for this object.
         *
         * @param tagrisSweepList
         *        The new value for the TagrisSweepList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagrisSweepList(TagrisSweepListItem... tagrisSweepList);

        /**
         * Sets the value of the TagrisSweepList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.firehose.model.TagrisSweepListItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.firehose.model.TagrisSweepListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.firehose.model.TagrisSweepListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #tagrisSweepList(List<TagrisSweepListItem>)}.
         * 
         * @param tagrisSweepList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.firehose.model.TagrisSweepListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagrisSweepList(java.util.Collection<TagrisSweepListItem>)
         */
        Builder tagrisSweepList(Consumer<TagrisSweepListItem.Builder>... tagrisSweepList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private List<TagrisSweepListItem> tagrisSweepList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyResourcesExistForTagrisRequest model) {
            super(model);
            tagrisSweepList(model.tagrisSweepList);
        }

        public final List<TagrisSweepListItem.Builder> getTagrisSweepList() {
            List<TagrisSweepListItem.Builder> result = TagrisSweepListCopier.copyToBuilder(this.tagrisSweepList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagrisSweepList(Collection<TagrisSweepListItem.BuilderImpl> tagrisSweepList) {
            this.tagrisSweepList = TagrisSweepListCopier.copyFromBuilder(tagrisSweepList);
        }

        @Override
        public final Builder tagrisSweepList(Collection<TagrisSweepListItem> tagrisSweepList) {
            this.tagrisSweepList = TagrisSweepListCopier.copy(tagrisSweepList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagrisSweepList(TagrisSweepListItem... tagrisSweepList) {
            tagrisSweepList(Arrays.asList(tagrisSweepList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagrisSweepList(Consumer<TagrisSweepListItem.Builder>... tagrisSweepList) {
            tagrisSweepList(Stream.of(tagrisSweepList).map(c -> TagrisSweepListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyResourcesExistForTagrisRequest build() {
            return new VerifyResourcesExistForTagrisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
