/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReleaseLabelsRequest extends EmrRequest implements
        ToCopyableBuilder<ListReleaseLabelsRequest.Builder, ListReleaseLabelsRequest> {
    private static final SdkField<ReleaseLabelFilter> FILTERS_FIELD = SdkField
            .<ReleaseLabelFilter> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(ListReleaseLabelsRequest::filters)).setter(setter(Builder::filters))
            .constructor(ReleaseLabelFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReleaseLabelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListReleaseLabelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final ReleaseLabelFilter filters;

    private final String nextToken;

    private final Integer maxResults;

    private ListReleaseLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return.
     * <code>Application</code> specifies the application (with/without version) of release labels to return.
     * </p>
     * 
     * @return Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return.
     *         <code>Application</code> specifies the application (with/without version) of release labels to return.
     */
    public final ReleaseLabelFilter filters() {
        return filters;
    }

    /**
     * <p>
     * Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the
     * first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by
     * the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account
     * ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is
     * expired or tampered with.
     * </p>
     * 
     * @return Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case
     *         for the first request of ListReleaseLabels, the first page of results are determined by other filtering
     *         parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity
     *         (Amazon Web Services account ID) and all filtering parameters are different from the original request, or
     *         if the <code>NextToken</code> is expired or tampered with.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.
     * </p>
     * 
     * @return Defines the maximum number of release labels to return in a single response. The default is
     *         <code>100</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReleaseLabelsRequest)) {
            return false;
        }
        ListReleaseLabelsRequest other = (ListReleaseLabelsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReleaseLabelsRequest").add("Filters", filters()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReleaseLabelsRequest, T> g) {
        return obj -> g.apply((ListReleaseLabelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListReleaseLabelsRequest> {
        /**
         * <p>
         * Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return.
         * <code>Application</code> specifies the application (with/without version) of release labels to return.
         * </p>
         * 
         * @param filters
         *        Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to
         *        return. <code>Application</code> specifies the application (with/without version) of release labels to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ReleaseLabelFilter filters);

        /**
         * <p>
         * Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return.
         * <code>Application</code> specifies the application (with/without version) of release labels to return.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReleaseLabelFilter.Builder} avoiding the
         * need to create one manually via {@link ReleaseLabelFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReleaseLabelFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(ReleaseLabelFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ReleaseLabelFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ReleaseLabelFilter)
         */
        default Builder filters(Consumer<ReleaseLabelFilter.Builder> filters) {
            return filters(ReleaseLabelFilter.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for
         * the first request of ListReleaseLabels, the first page of results are determined by other filtering
         * parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon
         * Web Services account ID) and all filtering parameters are different from the original request, or if the
         * <code>NextToken</code> is expired or tampered with.
         * </p>
         * 
         * @param nextToken
         *        Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the
         *        case for the first request of ListReleaseLabels, the first page of results are determined by other
         *        filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the
         *        identity (Amazon Web Services account ID) and all filtering parameters are different from the original
         *        request, or if the <code>NextToken</code> is expired or tampered with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.
         * </p>
         * 
         * @param maxResults
         *        Defines the maximum number of release labels to return in a single response. The default is
         *        <code>100</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private ReleaseLabelFilter filters;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReleaseLabelsRequest model) {
            super(model);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final ReleaseLabelFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ReleaseLabelFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ReleaseLabelFilter filters) {
            this.filters = filters;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReleaseLabelsRequest build() {
            return new ListReleaseLabelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
