/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of an Elasticsearch domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticsearchDomainConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticsearchDomainConfig.Builder, ElasticsearchDomainConfig> {
    private static final SdkField<ElasticsearchVersionStatus> ELASTICSEARCH_VERSION_FIELD = SdkField
            .<ElasticsearchVersionStatus> builder(MarshallingType.SDK_POJO).memberName("ElasticsearchVersion")
            .getter(getter(ElasticsearchDomainConfig::elasticsearchVersion)).setter(setter(Builder::elasticsearchVersion))
            .constructor(ElasticsearchVersionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build())
            .build();

    private static final SdkField<ElasticsearchClusterConfigStatus> ELASTICSEARCH_CLUSTER_CONFIG_FIELD = SdkField
            .<ElasticsearchClusterConfigStatus> builder(MarshallingType.SDK_POJO)
            .memberName("ElasticsearchClusterConfig")
            .getter(getter(ElasticsearchDomainConfig::elasticsearchClusterConfig))
            .setter(setter(Builder::elasticsearchClusterConfig))
            .constructor(ElasticsearchClusterConfigStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchClusterConfig").build())
            .build();

    private static final SdkField<EBSOptionsStatus> EBS_OPTIONS_FIELD = SdkField
            .<EBSOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("EBSOptions")
            .getter(getter(ElasticsearchDomainConfig::ebsOptions)).setter(setter(Builder::ebsOptions))
            .constructor(EBSOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()).build();

    private static final SdkField<AccessPoliciesStatus> ACCESS_POLICIES_FIELD = SdkField
            .<AccessPoliciesStatus> builder(MarshallingType.SDK_POJO).memberName("AccessPolicies")
            .getter(getter(ElasticsearchDomainConfig::accessPolicies)).setter(setter(Builder::accessPolicies))
            .constructor(AccessPoliciesStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()).build();

    private static final SdkField<SnapshotOptionsStatus> SNAPSHOT_OPTIONS_FIELD = SdkField
            .<SnapshotOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("SnapshotOptions")
            .getter(getter(ElasticsearchDomainConfig::snapshotOptions)).setter(setter(Builder::snapshotOptions))
            .constructor(SnapshotOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()).build();

    private static final SdkField<VPCDerivedInfoStatus> VPC_OPTIONS_FIELD = SdkField
            .<VPCDerivedInfoStatus> builder(MarshallingType.SDK_POJO).memberName("VPCOptions")
            .getter(getter(ElasticsearchDomainConfig::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(VPCDerivedInfoStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()).build();

    private static final SdkField<CognitoOptionsStatus> COGNITO_OPTIONS_FIELD = SdkField
            .<CognitoOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("CognitoOptions")
            .getter(getter(ElasticsearchDomainConfig::cognitoOptions)).setter(setter(Builder::cognitoOptions))
            .constructor(CognitoOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()).build();

    private static final SdkField<EncryptionAtRestOptionsStatus> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField
            .<EncryptionAtRestOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions")
            .getter(getter(ElasticsearchDomainConfig::encryptionAtRestOptions)).setter(setter(Builder::encryptionAtRestOptions))
            .constructor(EncryptionAtRestOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build())
            .build();

    private static final SdkField<NodeToNodeEncryptionOptionsStatus> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<NodeToNodeEncryptionOptionsStatus> builder(MarshallingType.SDK_POJO)
            .memberName("NodeToNodeEncryptionOptions")
            .getter(getter(ElasticsearchDomainConfig::nodeToNodeEncryptionOptions))
            .setter(setter(Builder::nodeToNodeEncryptionOptions))
            .constructor(NodeToNodeEncryptionOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions")
                    .build()).build();

    private static final SdkField<AdvancedOptionsStatus> ADVANCED_OPTIONS_FIELD = SdkField
            .<AdvancedOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("AdvancedOptions")
            .getter(getter(ElasticsearchDomainConfig::advancedOptions)).setter(setter(Builder::advancedOptions))
            .constructor(AdvancedOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build()).build();

    private static final SdkField<LogPublishingOptionsStatus> LOG_PUBLISHING_OPTIONS_FIELD = SdkField
            .<LogPublishingOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("LogPublishingOptions")
            .getter(getter(ElasticsearchDomainConfig::logPublishingOptions)).setter(setter(Builder::logPublishingOptions))
            .constructor(LogPublishingOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build())
            .build();

    private static final SdkField<DomainEndpointOptionsStatus> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<DomainEndpointOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("DomainEndpointOptions")
            .getter(getter(ElasticsearchDomainConfig::domainEndpointOptions)).setter(setter(Builder::domainEndpointOptions))
            .constructor(DomainEndpointOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final SdkField<AdvancedSecurityOptionsStatus> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField
            .<AdvancedSecurityOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions")
            .getter(getter(ElasticsearchDomainConfig::advancedSecurityOptions)).setter(setter(Builder::advancedSecurityOptions))
            .constructor(AdvancedSecurityOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build())
            .build();

    private static final SdkField<AutoTuneOptionsStatus> AUTO_TUNE_OPTIONS_FIELD = SdkField
            .<AutoTuneOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("AutoTuneOptions")
            .getter(getter(ElasticsearchDomainConfig::autoTuneOptions)).setter(setter(Builder::autoTuneOptions))
            .constructor(AutoTuneOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()).build();

    private static final SdkField<ChangeProgressDetails> CHANGE_PROGRESS_DETAILS_FIELD = SdkField
            .<ChangeProgressDetails> builder(MarshallingType.SDK_POJO).memberName("ChangeProgressDetails")
            .getter(getter(ElasticsearchDomainConfig::changeProgressDetails)).setter(setter(Builder::changeProgressDetails))
            .constructor(ChangeProgressDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressDetails").build())
            .build();

    private static final SdkField<List<ModifyingProperties>> MODIFYING_PROPERTIES_FIELD = SdkField
            .<List<ModifyingProperties>> builder(MarshallingType.LIST)
            .memberName("ModifyingProperties")
            .getter(getter(ElasticsearchDomainConfig::modifyingProperties))
            .setter(setter(Builder::modifyingProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifyingProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModifyingProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModifyingProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTICSEARCH_VERSION_FIELD,
            ELASTICSEARCH_CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, SNAPSHOT_OPTIONS_FIELD,
            VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD,
            ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD,
            AUTO_TUNE_OPTIONS_FIELD, CHANGE_PROGRESS_DETAILS_FIELD, MODIFYING_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ElasticsearchVersionStatus elasticsearchVersion;

    private final ElasticsearchClusterConfigStatus elasticsearchClusterConfig;

    private final EBSOptionsStatus ebsOptions;

    private final AccessPoliciesStatus accessPolicies;

    private final SnapshotOptionsStatus snapshotOptions;

    private final VPCDerivedInfoStatus vpcOptions;

    private final CognitoOptionsStatus cognitoOptions;

    private final EncryptionAtRestOptionsStatus encryptionAtRestOptions;

    private final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;

    private final AdvancedOptionsStatus advancedOptions;

    private final LogPublishingOptionsStatus logPublishingOptions;

    private final DomainEndpointOptionsStatus domainEndpointOptions;

    private final AdvancedSecurityOptionsStatus advancedSecurityOptions;

    private final AutoTuneOptionsStatus autoTuneOptions;

    private final ChangeProgressDetails changeProgressDetails;

    private final List<ModifyingProperties> modifyingProperties;

    private ElasticsearchDomainConfig(BuilderImpl builder) {
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.autoTuneOptions = builder.autoTuneOptions;
        this.changeProgressDetails = builder.changeProgressDetails;
        this.modifyingProperties = builder.modifyingProperties;
    }

    /**
     * <p>
     * String of format X.Y to specify version for the Elasticsearch domain.
     * </p>
     * 
     * @return String of format X.Y to specify version for the Elasticsearch domain.
     */
    public final ElasticsearchVersionStatus elasticsearchVersion() {
        return elasticsearchVersion;
    }

    /**
     * <p>
     * Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.
     */
    public final ElasticsearchClusterConfigStatus elasticsearchClusterConfig() {
        return elasticsearchClusterConfig;
    }

    /**
     * <p>
     * Specifies the <code>EBSOptions</code> for the Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code>EBSOptions</code> for the Elasticsearch domain.
     */
    public final EBSOptionsStatus ebsOptions() {
        return ebsOptions;
    }

    /**
     * <p>
     * IAM access policy as a JSON-formatted string.
     * </p>
     * 
     * @return IAM access policy as a JSON-formatted string.
     */
    public final AccessPoliciesStatus accessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.
     */
    public final SnapshotOptionsStatus snapshotOptions() {
        return snapshotOptions;
    }

    /**
     * <p>
     * The <code>VPCOptions</code> for the specified domain. For more information, see <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC
     * Endpoints for Amazon Elasticsearch Service Domains</a>.
     * </p>
     * 
     * @return The <code>VPCOptions</code> for the specified domain. For more information, see <a
     *         href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html"
     *         target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.
     */
    public final VPCDerivedInfoStatus vpcOptions() {
        return vpcOptions;
    }

    /**
     * <p>
     * The <code>CognitoOptions</code> for the specified domain. For more information, see <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html"
     * target="_blank">Amazon Cognito Authentication for Kibana</a>.
     * </p>
     * 
     * @return The <code>CognitoOptions</code> for the specified domain. For more information, see <a
     *         href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html"
     *         target="_blank">Amazon Cognito Authentication for Kibana</a>.
     */
    public final CognitoOptionsStatus cognitoOptions() {
        return cognitoOptions;
    }

    /**
     * <p>
     * Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.
     */
    public final EncryptionAtRestOptionsStatus encryptionAtRestOptions() {
        return encryptionAtRestOptions;
    }

    /**
     * <p>
     * Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.
     */
    public final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions() {
        return nodeToNodeEncryptionOptions;
    }

    /**
     * <p>
     * Specifies the <code>AdvancedOptions</code> for the domain. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options"
     * target="_blank">Configuring Advanced Options</a> for more information.
     * </p>
     * 
     * @return Specifies the <code>AdvancedOptions</code> for the domain. See <a href=
     *         "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options"
     *         target="_blank">Configuring Advanced Options</a> for more information.
     */
    public final AdvancedOptionsStatus advancedOptions() {
        return advancedOptions;
    }

    /**
     * <p>
     * Log publishing options for the given domain.
     * </p>
     * 
     * @return Log publishing options for the given domain.
     */
    public final LogPublishingOptionsStatus logPublishingOptions() {
        return logPublishingOptions;
    }

    /**
     * <p>
     * Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.
     * </p>
     * 
     * @return Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.
     */
    public final DomainEndpointOptionsStatus domainEndpointOptions() {
        return domainEndpointOptions;
    }

    /**
     * <p>
     * Specifies <code>AdvancedSecurityOptions</code> for the domain.
     * </p>
     * 
     * @return Specifies <code>AdvancedSecurityOptions</code> for the domain.
     */
    public final AdvancedSecurityOptionsStatus advancedSecurityOptions() {
        return advancedSecurityOptions;
    }

    /**
     * <p>
     * Specifies <code>AutoTuneOptions</code> for the domain.
     * </p>
     * 
     * @return Specifies <code>AutoTuneOptions</code> for the domain.
     */
    public final AutoTuneOptionsStatus autoTuneOptions() {
        return autoTuneOptions;
    }

    /**
     * <p>
     * Specifies change details of the domain configuration change.
     * </p>
     * 
     * @return Specifies change details of the domain configuration change.
     */
    public final ChangeProgressDetails changeProgressDetails() {
        return changeProgressDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModifyingProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModifyingProperties() {
        return modifyingProperties != null && !(modifyingProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the domain properties that are currently being modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModifyingProperties} method.
     * </p>
     * 
     * @return Information about the domain properties that are currently being modified.
     */
    public final List<ModifyingProperties> modifyingProperties() {
        return modifyingProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(autoTuneOptions());
        hashCode = 31 * hashCode + Objects.hashCode(changeProgressDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasModifyingProperties() ? modifyingProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDomainConfig)) {
            return false;
        }
        ElasticsearchDomainConfig other = (ElasticsearchDomainConfig) obj;
        return Objects.equals(elasticsearchVersion(), other.elasticsearchVersion())
                && Objects.equals(elasticsearchClusterConfig(), other.elasticsearchClusterConfig())
                && Objects.equals(ebsOptions(), other.ebsOptions()) && Objects.equals(accessPolicies(), other.accessPolicies())
                && Objects.equals(snapshotOptions(), other.snapshotOptions()) && Objects.equals(vpcOptions(), other.vpcOptions())
                && Objects.equals(cognitoOptions(), other.cognitoOptions())
                && Objects.equals(encryptionAtRestOptions(), other.encryptionAtRestOptions())
                && Objects.equals(nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions())
                && Objects.equals(advancedOptions(), other.advancedOptions())
                && Objects.equals(logPublishingOptions(), other.logPublishingOptions())
                && Objects.equals(domainEndpointOptions(), other.domainEndpointOptions())
                && Objects.equals(advancedSecurityOptions(), other.advancedSecurityOptions())
                && Objects.equals(autoTuneOptions(), other.autoTuneOptions())
                && Objects.equals(changeProgressDetails(), other.changeProgressDetails())
                && hasModifyingProperties() == other.hasModifyingProperties()
                && Objects.equals(modifyingProperties(), other.modifyingProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticsearchDomainConfig").add("ElasticsearchVersion", elasticsearchVersion())
                .add("ElasticsearchClusterConfig", elasticsearchClusterConfig()).add("EBSOptions", ebsOptions())
                .add("AccessPolicies", accessPolicies()).add("SnapshotOptions", snapshotOptions())
                .add("VPCOptions", vpcOptions()).add("CognitoOptions", cognitoOptions())
                .add("EncryptionAtRestOptions", encryptionAtRestOptions())
                .add("NodeToNodeEncryptionOptions", nodeToNodeEncryptionOptions()).add("AdvancedOptions", advancedOptions())
                .add("LogPublishingOptions", logPublishingOptions()).add("DomainEndpointOptions", domainEndpointOptions())
                .add("AdvancedSecurityOptions", advancedSecurityOptions()).add("AutoTuneOptions", autoTuneOptions())
                .add("ChangeProgressDetails", changeProgressDetails())
                .add("ModifyingProperties", hasModifyingProperties() ? modifyingProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticsearchVersion":
            return Optional.ofNullable(clazz.cast(elasticsearchVersion()));
        case "ElasticsearchClusterConfig":
            return Optional.ofNullable(clazz.cast(elasticsearchClusterConfig()));
        case "EBSOptions":
            return Optional.ofNullable(clazz.cast(ebsOptions()));
        case "AccessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        case "SnapshotOptions":
            return Optional.ofNullable(clazz.cast(snapshotOptions()));
        case "VPCOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        case "CognitoOptions":
            return Optional.ofNullable(clazz.cast(cognitoOptions()));
        case "EncryptionAtRestOptions":
            return Optional.ofNullable(clazz.cast(encryptionAtRestOptions()));
        case "NodeToNodeEncryptionOptions":
            return Optional.ofNullable(clazz.cast(nodeToNodeEncryptionOptions()));
        case "AdvancedOptions":
            return Optional.ofNullable(clazz.cast(advancedOptions()));
        case "LogPublishingOptions":
            return Optional.ofNullable(clazz.cast(logPublishingOptions()));
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        case "AdvancedSecurityOptions":
            return Optional.ofNullable(clazz.cast(advancedSecurityOptions()));
        case "AutoTuneOptions":
            return Optional.ofNullable(clazz.cast(autoTuneOptions()));
        case "ChangeProgressDetails":
            return Optional.ofNullable(clazz.cast(changeProgressDetails()));
        case "ModifyingProperties":
            return Optional.ofNullable(clazz.cast(modifyingProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDomainConfig, T> g) {
        return obj -> g.apply((ElasticsearchDomainConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticsearchDomainConfig> {
        /**
         * <p>
         * String of format X.Y to specify version for the Elasticsearch domain.
         * </p>
         * 
         * @param elasticsearchVersion
         *        String of format X.Y to specify version for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchVersion(ElasticsearchVersionStatus elasticsearchVersion);

        /**
         * <p>
         * String of format X.Y to specify version for the Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticsearchVersionStatus.Builder}
         * avoiding the need to create one manually via {@link ElasticsearchVersionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticsearchVersionStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #elasticsearchVersion(ElasticsearchVersionStatus)}.
         * 
         * @param elasticsearchVersion
         *        a consumer that will call methods on {@link ElasticsearchVersionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchVersion(ElasticsearchVersionStatus)
         */
        default Builder elasticsearchVersion(Consumer<ElasticsearchVersionStatus.Builder> elasticsearchVersion) {
            return elasticsearchVersion(ElasticsearchVersionStatus.builder().applyMutation(elasticsearchVersion).build());
        }

        /**
         * <p>
         * Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.
         * </p>
         * 
         * @param elasticsearchClusterConfig
         *        Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus elasticsearchClusterConfig);

        /**
         * <p>
         * Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticsearchClusterConfigStatus.Builder}
         * avoiding the need to create one manually via {@link ElasticsearchClusterConfigStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticsearchClusterConfigStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticsearchClusterConfig(ElasticsearchClusterConfigStatus)}.
         * 
         * @param elasticsearchClusterConfig
         *        a consumer that will call methods on {@link ElasticsearchClusterConfigStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchClusterConfig(ElasticsearchClusterConfigStatus)
         */
        default Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfigStatus.Builder> elasticsearchClusterConfig) {
            return elasticsearchClusterConfig(ElasticsearchClusterConfigStatus.builder()
                    .applyMutation(elasticsearchClusterConfig).build());
        }

        /**
         * <p>
         * Specifies the <code>EBSOptions</code> for the Elasticsearch domain.
         * </p>
         * 
         * @param ebsOptions
         *        Specifies the <code>EBSOptions</code> for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptions(EBSOptionsStatus ebsOptions);

        /**
         * <p>
         * Specifies the <code>EBSOptions</code> for the Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link EBSOptionsStatus.Builder} avoiding the
         * need to create one manually via {@link EBSOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EBSOptionsStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #ebsOptions(EBSOptionsStatus)}.
         * 
         * @param ebsOptions
         *        a consumer that will call methods on {@link EBSOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsOptions(EBSOptionsStatus)
         */
        default Builder ebsOptions(Consumer<EBSOptionsStatus.Builder> ebsOptions) {
            return ebsOptions(EBSOptionsStatus.builder().applyMutation(ebsOptions).build());
        }

        /**
         * <p>
         * IAM access policy as a JSON-formatted string.
         * </p>
         * 
         * @param accessPolicies
         *        IAM access policy as a JSON-formatted string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(AccessPoliciesStatus accessPolicies);

        /**
         * <p>
         * IAM access policy as a JSON-formatted string.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessPoliciesStatus.Builder} avoiding
         * the need to create one manually via {@link AccessPoliciesStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessPoliciesStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #accessPolicies(AccessPoliciesStatus)}.
         * 
         * @param accessPolicies
         *        a consumer that will call methods on {@link AccessPoliciesStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicies(AccessPoliciesStatus)
         */
        default Builder accessPolicies(Consumer<AccessPoliciesStatus.Builder> accessPolicies) {
            return accessPolicies(AccessPoliciesStatus.builder().applyMutation(accessPolicies).build());
        }

        /**
         * <p>
         * Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.
         * </p>
         * 
         * @param snapshotOptions
         *        Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions);

        /**
         * <p>
         * Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link SnapshotOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotOptionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #snapshotOptions(SnapshotOptionsStatus)}.
         * 
         * @param snapshotOptions
         *        a consumer that will call methods on {@link SnapshotOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotOptions(SnapshotOptionsStatus)
         */
        default Builder snapshotOptions(Consumer<SnapshotOptionsStatus.Builder> snapshotOptions) {
            return snapshotOptions(SnapshotOptionsStatus.builder().applyMutation(snapshotOptions).build());
        }

        /**
         * <p>
         * The <code>VPCOptions</code> for the specified domain. For more information, see <a
         * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC
         * Endpoints for Amazon Elasticsearch Service Domains</a>.
         * </p>
         * 
         * @param vpcOptions
         *        The <code>VPCOptions</code> for the specified domain. For more information, see <a
         *        href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html"
         *        target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(VPCDerivedInfoStatus vpcOptions);

        /**
         * <p>
         * The <code>VPCOptions</code> for the specified domain. For more information, see <a
         * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC
         * Endpoints for Amazon Elasticsearch Service Domains</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPCDerivedInfoStatus.Builder} avoiding
         * the need to create one manually via {@link VPCDerivedInfoStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VPCDerivedInfoStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcOptions(VPCDerivedInfoStatus)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link VPCDerivedInfoStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(VPCDerivedInfoStatus)
         */
        default Builder vpcOptions(Consumer<VPCDerivedInfoStatus.Builder> vpcOptions) {
            return vpcOptions(VPCDerivedInfoStatus.builder().applyMutation(vpcOptions).build());
        }

        /**
         * <p>
         * The <code>CognitoOptions</code> for the specified domain. For more information, see <a
         * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html"
         * target="_blank">Amazon Cognito Authentication for Kibana</a>.
         * </p>
         * 
         * @param cognitoOptions
         *        The <code>CognitoOptions</code> for the specified domain. For more information, see <a
         *        href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html"
         *        target="_blank">Amazon Cognito Authentication for Kibana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoOptions(CognitoOptionsStatus cognitoOptions);

        /**
         * <p>
         * The <code>CognitoOptions</code> for the specified domain. For more information, see <a
         * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html"
         * target="_blank">Amazon Cognito Authentication for Kibana</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CognitoOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link CognitoOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoOptionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #cognitoOptions(CognitoOptionsStatus)}.
         * 
         * @param cognitoOptions
         *        a consumer that will call methods on {@link CognitoOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoOptions(CognitoOptionsStatus)
         */
        default Builder cognitoOptions(Consumer<CognitoOptionsStatus.Builder> cognitoOptions) {
            return cognitoOptions(CognitoOptionsStatus.builder().applyMutation(cognitoOptions).build());
        }

        /**
         * <p>
         * Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.
         * </p>
         * 
         * @param encryptionAtRestOptions
         *        Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus encryptionAtRestOptions);

        /**
         * <p>
         * Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionAtRestOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link EncryptionAtRestOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionAtRestOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #encryptionAtRestOptions(EncryptionAtRestOptionsStatus)}.
         * 
         * @param encryptionAtRestOptions
         *        a consumer that will call methods on {@link EncryptionAtRestOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRestOptions(EncryptionAtRestOptionsStatus)
         */
        default Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptionsStatus.Builder> encryptionAtRestOptions) {
            return encryptionAtRestOptions(EncryptionAtRestOptionsStatus.builder().applyMutation(encryptionAtRestOptions).build());
        }

        /**
         * <p>
         * Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.
         * </p>
         * 
         * @param nodeToNodeEncryptionOptions
         *        Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions);

        /**
         * <p>
         * Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link NodeToNodeEncryptionOptionsStatus.Builder} avoiding the need to create one manually via
         * {@link NodeToNodeEncryptionOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeToNodeEncryptionOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus)}.
         * 
         * @param nodeToNodeEncryptionOptions
         *        a consumer that will call methods on {@link NodeToNodeEncryptionOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus)
         */
        default Builder nodeToNodeEncryptionOptions(
                Consumer<NodeToNodeEncryptionOptionsStatus.Builder> nodeToNodeEncryptionOptions) {
            return nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus.builder()
                    .applyMutation(nodeToNodeEncryptionOptions).build());
        }

        /**
         * <p>
         * Specifies the <code>AdvancedOptions</code> for the domain. See <a href=
         * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options"
         * target="_blank">Configuring Advanced Options</a> for more information.
         * </p>
         * 
         * @param advancedOptions
         *        Specifies the <code>AdvancedOptions</code> for the domain. See <a href=
         *        "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options"
         *        target="_blank">Configuring Advanced Options</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedOptions(AdvancedOptionsStatus advancedOptions);

        /**
         * <p>
         * Specifies the <code>AdvancedOptions</code> for the domain. See <a href=
         * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options"
         * target="_blank">Configuring Advanced Options</a> for more information.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link AdvancedOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedOptionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #advancedOptions(AdvancedOptionsStatus)}.
         * 
         * @param advancedOptions
         *        a consumer that will call methods on {@link AdvancedOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedOptions(AdvancedOptionsStatus)
         */
        default Builder advancedOptions(Consumer<AdvancedOptionsStatus.Builder> advancedOptions) {
            return advancedOptions(AdvancedOptionsStatus.builder().applyMutation(advancedOptions).build());
        }

        /**
         * <p>
         * Log publishing options for the given domain.
         * </p>
         * 
         * @param logPublishingOptions
         *        Log publishing options for the given domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptions(LogPublishingOptionsStatus logPublishingOptions);

        /**
         * <p>
         * Log publishing options for the given domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogPublishingOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link LogPublishingOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogPublishingOptionsStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #logPublishingOptions(LogPublishingOptionsStatus)}.
         * 
         * @param logPublishingOptions
         *        a consumer that will call methods on {@link LogPublishingOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingOptions(LogPublishingOptionsStatus)
         */
        default Builder logPublishingOptions(Consumer<LogPublishingOptionsStatus.Builder> logPublishingOptions) {
            return logPublishingOptions(LogPublishingOptionsStatus.builder().applyMutation(logPublishingOptions).build());
        }

        /**
         * <p>
         * Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.
         * </p>
         * 
         * @param domainEndpointOptions
         *        Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions);

        /**
         * <p>
         * Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainEndpointOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link DomainEndpointOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainEndpointOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #domainEndpointOptions(DomainEndpointOptionsStatus)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on {@link DomainEndpointOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(DomainEndpointOptionsStatus)
         */
        default Builder domainEndpointOptions(Consumer<DomainEndpointOptionsStatus.Builder> domainEndpointOptions) {
            return domainEndpointOptions(DomainEndpointOptionsStatus.builder().applyMutation(domainEndpointOptions).build());
        }

        /**
         * <p>
         * Specifies <code>AdvancedSecurityOptions</code> for the domain.
         * </p>
         * 
         * @param advancedSecurityOptions
         *        Specifies <code>AdvancedSecurityOptions</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus advancedSecurityOptions);

        /**
         * <p>
         * Specifies <code>AdvancedSecurityOptions</code> for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedSecurityOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link AdvancedSecurityOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedSecurityOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedSecurityOptions(AdvancedSecurityOptionsStatus)}.
         * 
         * @param advancedSecurityOptions
         *        a consumer that will call methods on {@link AdvancedSecurityOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedSecurityOptions(AdvancedSecurityOptionsStatus)
         */
        default Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptionsStatus.Builder> advancedSecurityOptions) {
            return advancedSecurityOptions(AdvancedSecurityOptionsStatus.builder().applyMutation(advancedSecurityOptions).build());
        }

        /**
         * <p>
         * Specifies <code>AutoTuneOptions</code> for the domain.
         * </p>
         * 
         * @param autoTuneOptions
         *        Specifies <code>AutoTuneOptions</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTuneOptions(AutoTuneOptionsStatus autoTuneOptions);

        /**
         * <p>
         * Specifies <code>AutoTuneOptions</code> for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoTuneOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link AutoTuneOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoTuneOptionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #autoTuneOptions(AutoTuneOptionsStatus)}.
         * 
         * @param autoTuneOptions
         *        a consumer that will call methods on {@link AutoTuneOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTuneOptions(AutoTuneOptionsStatus)
         */
        default Builder autoTuneOptions(Consumer<AutoTuneOptionsStatus.Builder> autoTuneOptions) {
            return autoTuneOptions(AutoTuneOptionsStatus.builder().applyMutation(autoTuneOptions).build());
        }

        /**
         * <p>
         * Specifies change details of the domain configuration change.
         * </p>
         * 
         * @param changeProgressDetails
         *        Specifies change details of the domain configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails);

        /**
         * <p>
         * Specifies change details of the domain configuration change.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChangeProgressDetails.Builder} avoiding
         * the need to create one manually via {@link ChangeProgressDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeProgressDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #changeProgressDetails(ChangeProgressDetails)}.
         * 
         * @param changeProgressDetails
         *        a consumer that will call methods on {@link ChangeProgressDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeProgressDetails(ChangeProgressDetails)
         */
        default Builder changeProgressDetails(Consumer<ChangeProgressDetails.Builder> changeProgressDetails) {
            return changeProgressDetails(ChangeProgressDetails.builder().applyMutation(changeProgressDetails).build());
        }

        /**
         * <p>
         * Information about the domain properties that are currently being modified.
         * </p>
         * 
         * @param modifyingProperties
         *        Information about the domain properties that are currently being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifyingProperties(Collection<ModifyingProperties> modifyingProperties);

        /**
         * <p>
         * Information about the domain properties that are currently being modified.
         * </p>
         * 
         * @param modifyingProperties
         *        Information about the domain properties that are currently being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifyingProperties(ModifyingProperties... modifyingProperties);

        /**
         * <p>
         * Information about the domain properties that are currently being modified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #modifyingProperties(List<ModifyingProperties>)}.
         * 
         * @param modifyingProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modifyingProperties(java.util.Collection<ModifyingProperties>)
         */
        Builder modifyingProperties(Consumer<ModifyingProperties.Builder>... modifyingProperties);
    }

    static final class BuilderImpl implements Builder {
        private ElasticsearchVersionStatus elasticsearchVersion;

        private ElasticsearchClusterConfigStatus elasticsearchClusterConfig;

        private EBSOptionsStatus ebsOptions;

        private AccessPoliciesStatus accessPolicies;

        private SnapshotOptionsStatus snapshotOptions;

        private VPCDerivedInfoStatus vpcOptions;

        private CognitoOptionsStatus cognitoOptions;

        private EncryptionAtRestOptionsStatus encryptionAtRestOptions;

        private NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;

        private AdvancedOptionsStatus advancedOptions;

        private LogPublishingOptionsStatus logPublishingOptions;

        private DomainEndpointOptionsStatus domainEndpointOptions;

        private AdvancedSecurityOptionsStatus advancedSecurityOptions;

        private AutoTuneOptionsStatus autoTuneOptions;

        private ChangeProgressDetails changeProgressDetails;

        private List<ModifyingProperties> modifyingProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDomainConfig model) {
            elasticsearchVersion(model.elasticsearchVersion);
            elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            ebsOptions(model.ebsOptions);
            accessPolicies(model.accessPolicies);
            snapshotOptions(model.snapshotOptions);
            vpcOptions(model.vpcOptions);
            cognitoOptions(model.cognitoOptions);
            encryptionAtRestOptions(model.encryptionAtRestOptions);
            nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            advancedOptions(model.advancedOptions);
            logPublishingOptions(model.logPublishingOptions);
            domainEndpointOptions(model.domainEndpointOptions);
            advancedSecurityOptions(model.advancedSecurityOptions);
            autoTuneOptions(model.autoTuneOptions);
            changeProgressDetails(model.changeProgressDetails);
            modifyingProperties(model.modifyingProperties);
        }

        public final ElasticsearchVersionStatus.Builder getElasticsearchVersion() {
            return elasticsearchVersion != null ? elasticsearchVersion.toBuilder() : null;
        }

        public final void setElasticsearchVersion(ElasticsearchVersionStatus.BuilderImpl elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion != null ? elasticsearchVersion.build() : null;
        }

        @Override
        public final Builder elasticsearchVersion(ElasticsearchVersionStatus elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final ElasticsearchClusterConfigStatus.Builder getElasticsearchClusterConfig() {
            return elasticsearchClusterConfig != null ? elasticsearchClusterConfig.toBuilder() : null;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfigStatus.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final EBSOptionsStatus.Builder getEbsOptions() {
            return ebsOptions != null ? ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptionsStatus.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final AccessPoliciesStatus.Builder getAccessPolicies() {
            return accessPolicies != null ? accessPolicies.toBuilder() : null;
        }

        public final void setAccessPolicies(AccessPoliciesStatus.BuilderImpl accessPolicies) {
            this.accessPolicies = accessPolicies != null ? accessPolicies.build() : null;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final SnapshotOptionsStatus.Builder getSnapshotOptions() {
            return snapshotOptions != null ? snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptionsStatus.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCDerivedInfoStatus.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCDerivedInfoStatus.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfoStatus vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptionsStatus.Builder getCognitoOptions() {
            return cognitoOptions != null ? cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptionsStatus.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptionsStatus cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final EncryptionAtRestOptionsStatus.Builder getEncryptionAtRestOptions() {
            return encryptionAtRestOptions != null ? encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptionsStatus.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptionsStatus.Builder getNodeToNodeEncryptionOptions() {
            return nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final AdvancedOptionsStatus.Builder getAdvancedOptions() {
            return advancedOptions != null ? advancedOptions.toBuilder() : null;
        }

        public final void setAdvancedOptions(AdvancedOptionsStatus.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public final LogPublishingOptionsStatus.Builder getLogPublishingOptions() {
            return logPublishingOptions != null ? logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(LogPublishingOptionsStatus.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptionsStatus logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final DomainEndpointOptionsStatus.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptionsStatus.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptionsStatus.Builder getAdvancedSecurityOptions() {
            return advancedSecurityOptions != null ? advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptionsStatus.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final AutoTuneOptionsStatus.Builder getAutoTuneOptions() {
            return autoTuneOptions != null ? autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptionsStatus.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        public final Builder autoTuneOptions(AutoTuneOptionsStatus autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        public final ChangeProgressDetails.Builder getChangeProgressDetails() {
            return changeProgressDetails != null ? changeProgressDetails.toBuilder() : null;
        }

        public final void setChangeProgressDetails(ChangeProgressDetails.BuilderImpl changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails != null ? changeProgressDetails.build() : null;
        }

        @Override
        public final Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails;
            return this;
        }

        public final List<ModifyingProperties.Builder> getModifyingProperties() {
            List<ModifyingProperties.Builder> result = ModifyingPropertiesListCopier.copyToBuilder(this.modifyingProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModifyingProperties(Collection<ModifyingProperties.BuilderImpl> modifyingProperties) {
            this.modifyingProperties = ModifyingPropertiesListCopier.copyFromBuilder(modifyingProperties);
        }

        @Override
        public final Builder modifyingProperties(Collection<ModifyingProperties> modifyingProperties) {
            this.modifyingProperties = ModifyingPropertiesListCopier.copy(modifyingProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifyingProperties(ModifyingProperties... modifyingProperties) {
            modifyingProperties(Arrays.asList(modifyingProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifyingProperties(Consumer<ModifyingProperties.Builder>... modifyingProperties) {
            modifyingProperties(Stream.of(modifyingProperties).map(c -> ModifyingProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ElasticsearchDomainConfig build() {
            return new ElasticsearchDomainConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
