/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationTableStatisticsResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeReplicationTableStatisticsResponse.Builder, DescribeReplicationTableStatisticsResponse> {
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigArn").getter(getter(DescribeReplicationTableStatisticsResponse::replicationConfigArn))
            .setter(setter(Builder::replicationConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReplicationTableStatisticsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<TableStatistics>> REPLICATION_TABLE_STATISTICS_FIELD = SdkField
            .<List<TableStatistics>> builder(MarshallingType.LIST)
            .memberName("ReplicationTableStatistics")
            .getter(getter(DescribeReplicationTableStatisticsResponse::replicationTableStatistics))
            .setter(setter(Builder::replicationTableStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTableStatistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_ARN_FIELD,
            MARKER_FIELD, REPLICATION_TABLE_STATISTICS_FIELD));

    private final String replicationConfigArn;

    private final String marker;

    private final List<TableStatistics> replicationTableStatistics;

    private DescribeReplicationTableStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationConfigArn = builder.replicationConfigArn;
        this.marker = builder.marker;
        this.replicationTableStatistics = builder.replicationTableStatistics;
    }

    /**
     * <p>
     * The Amazon Resource Name of the replication config.
     * </p>
     * 
     * @return The Amazon Resource Name of the replication config.
     */
    public final String replicationConfigArn() {
        return replicationConfigArn;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationTableStatistics property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicationTableStatistics() {
        return replicationTableStatistics != null && !(replicationTableStatistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns table statistics on the replication, including table name, rows inserted, rows updated, and rows deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationTableStatistics} method.
     * </p>
     * 
     * @return Returns table statistics on the replication, including table name, rows inserted, rows updated, and rows
     *         deleted.
     */
    public final List<TableStatistics> replicationTableStatistics() {
        return replicationTableStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationTableStatistics() ? replicationTableStatistics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTableStatisticsResponse)) {
            return false;
        }
        DescribeReplicationTableStatisticsResponse other = (DescribeReplicationTableStatisticsResponse) obj;
        return Objects.equals(replicationConfigArn(), other.replicationConfigArn()) && Objects.equals(marker(), other.marker())
                && hasReplicationTableStatistics() == other.hasReplicationTableStatistics()
                && Objects.equals(replicationTableStatistics(), other.replicationTableStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicationTableStatisticsResponse").add("ReplicationConfigArn", replicationConfigArn())
                .add("Marker", marker())
                .add("ReplicationTableStatistics", hasReplicationTableStatistics() ? replicationTableStatistics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationConfigArn":
            return Optional.ofNullable(clazz.cast(replicationConfigArn()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReplicationTableStatistics":
            return Optional.ofNullable(clazz.cast(replicationTableStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTableStatisticsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTableStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationTableStatisticsResponse> {
        /**
         * <p>
         * The Amazon Resource Name of the replication config.
         * </p>
         * 
         * @param replicationConfigArn
         *        The Amazon Resource Name of the replication config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigArn(String replicationConfigArn);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns table statistics on the replication, including table name, rows inserted, rows updated, and rows
         * deleted.
         * </p>
         * 
         * @param replicationTableStatistics
         *        Returns table statistics on the replication, including table name, rows inserted, rows updated, and
         *        rows deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTableStatistics(Collection<TableStatistics> replicationTableStatistics);

        /**
         * <p>
         * Returns table statistics on the replication, including table name, rows inserted, rows updated, and rows
         * deleted.
         * </p>
         * 
         * @param replicationTableStatistics
         *        Returns table statistics on the replication, including table name, rows inserted, rows updated, and
         *        rows deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTableStatistics(TableStatistics... replicationTableStatistics);

        /**
         * <p>
         * Returns table statistics on the replication, including table name, rows inserted, rows updated, and rows
         * deleted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.TableStatistics.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.TableStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.TableStatistics.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationTableStatistics(List<TableStatistics>)}.
         * 
         * @param replicationTableStatistics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.TableStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationTableStatistics(java.util.Collection<TableStatistics>)
         */
        Builder replicationTableStatistics(Consumer<TableStatistics.Builder>... replicationTableStatistics);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String replicationConfigArn;

        private String marker;

        private List<TableStatistics> replicationTableStatistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTableStatisticsResponse model) {
            super(model);
            replicationConfigArn(model.replicationConfigArn);
            marker(model.marker);
            replicationTableStatistics(model.replicationTableStatistics);
        }

        public final String getReplicationConfigArn() {
            return replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<TableStatistics.Builder> getReplicationTableStatistics() {
            List<TableStatistics.Builder> result = ReplicationTableStatisticsListCopier
                    .copyToBuilder(this.replicationTableStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationTableStatistics(Collection<TableStatistics.BuilderImpl> replicationTableStatistics) {
            this.replicationTableStatistics = ReplicationTableStatisticsListCopier.copyFromBuilder(replicationTableStatistics);
        }

        @Override
        public final Builder replicationTableStatistics(Collection<TableStatistics> replicationTableStatistics) {
            this.replicationTableStatistics = ReplicationTableStatisticsListCopier.copy(replicationTableStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTableStatistics(TableStatistics... replicationTableStatistics) {
            replicationTableStatistics(Arrays.asList(replicationTableStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTableStatistics(Consumer<TableStatistics.Builder>... replicationTableStatistics) {
            replicationTableStatistics(Stream.of(replicationTableStatistics)
                    .map(c -> TableStatistics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationTableStatisticsResponse build() {
            return new DescribeReplicationTableStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
