/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVocabularyResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeVocabularyResponse.Builder, DescribeVocabularyResponse> {
    private static final SdkField<Vocabulary> VOCABULARY_FIELD = SdkField.<Vocabulary> builder(MarshallingType.SDK_POJO)
            .memberName("Vocabulary").getter(getter(DescribeVocabularyResponse::vocabulary)).setter(setter(Builder::vocabulary))
            .constructor(Vocabulary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vocabulary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FIELD));

    private final Vocabulary vocabulary;

    private DescribeVocabularyResponse(BuilderImpl builder) {
        super(builder);
        this.vocabulary = builder.vocabulary;
    }

    /**
     * <p>
     * A list of specific words that you want Contact Lens for Amazon Connect to recognize in your audio input. They are
     * generally domain-specific words and phrases, words that Contact Lens is not recognizing, or proper nouns.
     * </p>
     * 
     * @return A list of specific words that you want Contact Lens for Amazon Connect to recognize in your audio input.
     *         They are generally domain-specific words and phrases, words that Contact Lens is not recognizing, or
     *         proper nouns.
     */
    public final Vocabulary vocabulary() {
        return vocabulary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabulary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVocabularyResponse)) {
            return false;
        }
        DescribeVocabularyResponse other = (DescribeVocabularyResponse) obj;
        return Objects.equals(vocabulary(), other.vocabulary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVocabularyResponse").add("Vocabulary", vocabulary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vocabulary":
            return Optional.ofNullable(clazz.cast(vocabulary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVocabularyResponse, T> g) {
        return obj -> g.apply((DescribeVocabularyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVocabularyResponse> {
        /**
         * <p>
         * A list of specific words that you want Contact Lens for Amazon Connect to recognize in your audio input. They
         * are generally domain-specific words and phrases, words that Contact Lens is not recognizing, or proper nouns.
         * </p>
         * 
         * @param vocabulary
         *        A list of specific words that you want Contact Lens for Amazon Connect to recognize in your audio
         *        input. They are generally domain-specific words and phrases, words that Contact Lens is not
         *        recognizing, or proper nouns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabulary(Vocabulary vocabulary);

        /**
         * <p>
         * A list of specific words that you want Contact Lens for Amazon Connect to recognize in your audio input. They
         * are generally domain-specific words and phrases, words that Contact Lens is not recognizing, or proper nouns.
         * </p>
         * This is a convenience method that creates an instance of the {@link Vocabulary.Builder} avoiding the need to
         * create one manually via {@link Vocabulary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Vocabulary.Builder#build()} is called immediately and its result
         * is passed to {@link #vocabulary(Vocabulary)}.
         * 
         * @param vocabulary
         *        a consumer that will call methods on {@link Vocabulary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vocabulary(Vocabulary)
         */
        default Builder vocabulary(Consumer<Vocabulary.Builder> vocabulary) {
            return vocabulary(Vocabulary.builder().applyMutation(vocabulary).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private Vocabulary vocabulary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVocabularyResponse model) {
            super(model);
            vocabulary(model.vocabulary);
        }

        public final Vocabulary.Builder getVocabulary() {
            return vocabulary != null ? vocabulary.toBuilder() : null;
        }

        public final void setVocabulary(Vocabulary.BuilderImpl vocabulary) {
            this.vocabulary = vocabulary != null ? vocabulary.build() : null;
        }

        @Override
        public final Builder vocabulary(Vocabulary vocabulary) {
            this.vocabulary = vocabulary;
            return this;
        }

        @Override
        public DescribeVocabularyResponse build() {
            return new DescribeVocabularyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
