/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the location of application artifacts stored in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Location implements SdkPojo, Serializable, ToCopyableBuilder<S3Location.Builder, S3Location> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("bucket")
            .getter(getter(S3Location::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(S3Location::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> BUNDLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleType").getter(getter(S3Location::bundleTypeAsString)).setter(setter(Builder::bundleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleType").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(S3Location::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("eTag")
            .getter(getter(S3Location::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_FIELD,
            BUNDLE_TYPE_FIELD, VERSION_FIELD, E_TAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String key;

    private final String bundleType;

    private final String version;

    private final String eTag;

    private S3Location(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.bundleType = builder.bundleType;
        this.version = builder.version;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where the application revision is stored.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where the application revision is stored.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
     * </p>
     * 
     * @return The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The file type of the application revision. Must be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tar</code>: A tar archive file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tgz</code>: A compressed tar archive file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zip</code>: A zip archive file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YAML</code>: A YAML-formatted file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JSON</code>: A JSON-formatted file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bundleType} will
     * return {@link BundleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bundleTypeAsString}.
     * </p>
     * 
     * @return The file type of the application revision. Must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>tar</code>: A tar archive file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tgz</code>: A compressed tar archive file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zip</code>: A zip archive file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YAML</code>: A YAML-formatted file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JSON</code>: A JSON-formatted file.
     *         </p>
     *         </li>
     * @see BundleType
     */
    public final BundleType bundleType() {
        return BundleType.fromValue(bundleType);
    }

    /**
     * <p>
     * The file type of the application revision. Must be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tar</code>: A tar archive file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tgz</code>: A compressed tar archive file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zip</code>: A zip archive file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YAML</code>: A YAML-formatted file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JSON</code>: A JSON-formatted file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bundleType} will
     * return {@link BundleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bundleTypeAsString}.
     * </p>
     * 
     * @return The file type of the application revision. Must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>tar</code>: A tar archive file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tgz</code>: A compressed tar archive file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zip</code>: A zip archive file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YAML</code>: A YAML-formatted file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JSON</code>: A JSON-formatted file.
     *         </p>
     *         </li>
     * @see BundleType
     */
    public final String bundleTypeAsString() {
        return bundleType;
    }

    /**
     * <p>
     * A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.
     * </p>
     * <p>
     * If the version is not specified, the system uses the most recent version by default.
     * </p>
     * 
     * @return A specific version of the Amazon S3 object that represents the bundled artifacts for the application
     *         revision.</p>
     *         <p>
     *         If the version is not specified, the system uses the most recent version by default.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.
     * </p>
     * <p>
     * If the ETag is not specified as an input parameter, ETag validation of the object is skipped.
     * </p>
     * 
     * @return The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
     *         <p>
     *         If the ETag is not specified as an input parameter, ETag validation of the object is skipped.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(bundleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(key(), other.key())
                && Objects.equals(bundleTypeAsString(), other.bundleTypeAsString()) && Objects.equals(version(), other.version())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Location").add("Bucket", bucket()).add("Key", key()).add("BundleType", bundleTypeAsString())
                .add("Version", version()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "bundleType":
            return Optional.ofNullable(clazz.cast(bundleTypeAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "eTag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Location, T> g) {
        return obj -> g.apply((S3Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Location> {
        /**
         * <p>
         * The name of the Amazon S3 bucket where the application revision is stored.
         * </p>
         * 
         * @param bucket
         *        The name of the Amazon S3 bucket where the application revision is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
         * </p>
         * 
         * @param key
         *        The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The file type of the application revision. Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tar</code>: A tar archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tgz</code>: A compressed tar archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zip</code>: A zip archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YAML</code>: A YAML-formatted file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JSON</code>: A JSON-formatted file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bundleType
         *        The file type of the application revision. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tar</code>: A tar archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tgz</code>: A compressed tar archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zip</code>: A zip archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YAML</code>: A YAML-formatted file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JSON</code>: A JSON-formatted file.
         *        </p>
         *        </li>
         * @see BundleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BundleType
         */
        Builder bundleType(String bundleType);

        /**
         * <p>
         * The file type of the application revision. Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tar</code>: A tar archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tgz</code>: A compressed tar archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zip</code>: A zip archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YAML</code>: A YAML-formatted file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JSON</code>: A JSON-formatted file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bundleType
         *        The file type of the application revision. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tar</code>: A tar archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tgz</code>: A compressed tar archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zip</code>: A zip archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YAML</code>: A YAML-formatted file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JSON</code>: A JSON-formatted file.
         *        </p>
         *        </li>
         * @see BundleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BundleType
         */
        Builder bundleType(BundleType bundleType);

        /**
         * <p>
         * A specific version of the Amazon S3 object that represents the bundled artifacts for the application
         * revision.
         * </p>
         * <p>
         * If the version is not specified, the system uses the most recent version by default.
         * </p>
         * 
         * @param version
         *        A specific version of the Amazon S3 object that represents the bundled artifacts for the application
         *        revision.</p>
         *        <p>
         *        If the version is not specified, the system uses the most recent version by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.
         * </p>
         * <p>
         * If the ETag is not specified as an input parameter, ETag validation of the object is skipped.
         * </p>
         * 
         * @param eTag
         *        The ETag of the Amazon S3 object that represents the bundled artifacts for the application
         *        revision.</p>
         *        <p>
         *        If the ETag is not specified as an input parameter, ETag validation of the object is skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private String bundleType;

        private String version;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            bucket(model.bucket);
            key(model.key);
            bundleType(model.bundleType);
            version(model.version);
            eTag(model.eTag);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getBundleType() {
            return bundleType;
        }

        public final void setBundleType(String bundleType) {
            this.bundleType = bundleType;
        }

        @Override
        public final Builder bundleType(String bundleType) {
            this.bundleType = bundleType;
            return this;
        }

        @Override
        public final Builder bundleType(BundleType bundleType) {
            this.bundleType(bundleType == null ? null : bundleType.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public S3Location build() {
            return new S3Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
