/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFleetResponse extends CodeBuildResponse implements
        ToCopyableBuilder<UpdateFleetResponse.Builder, UpdateFleetResponse> {
    private static final SdkField<Fleet> FLEET_FIELD = SdkField.<Fleet> builder(MarshallingType.SDK_POJO).memberName("fleet")
            .getter(getter(UpdateFleetResponse::fleet)).setter(setter(Builder::fleet)).constructor(Fleet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_FIELD));

    private final Fleet fleet;

    private UpdateFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleet = builder.fleet;
    }

    /**
     * <p>
     * A <code>Fleet</code> object.
     * </p>
     * 
     * @return A <code>Fleet</code> object.
     */
    public final Fleet fleet() {
        return fleet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetResponse)) {
            return false;
        }
        UpdateFleetResponse other = (UpdateFleetResponse) obj;
        return Objects.equals(fleet(), other.fleet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFleetResponse").add("Fleet", fleet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleet":
            return Optional.ofNullable(clazz.cast(fleet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetResponse, T> g) {
        return obj -> g.apply((UpdateFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFleetResponse> {
        /**
         * <p>
         * A <code>Fleet</code> object.
         * </p>
         * 
         * @param fleet
         *        A <code>Fleet</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(Fleet fleet);

        /**
         * <p>
         * A <code>Fleet</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link Fleet.Builder} avoiding the need to
         * create one manually via {@link Fleet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Fleet.Builder#build()} is called immediately and its result is
         * passed to {@link #fleet(Fleet)}.
         * 
         * @param fleet
         *        a consumer that will call methods on {@link Fleet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleet(Fleet)
         */
        default Builder fleet(Consumer<Fleet.Builder> fleet) {
            return fleet(Fleet.builder().applyMutation(fleet).build());
        }
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private Fleet fleet;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetResponse model) {
            super(model);
            fleet(model.fleet);
        }

        public final Fleet.Builder getFleet() {
            return fleet != null ? fleet.toBuilder() : null;
        }

        public final void setFleet(Fleet.BuilderImpl fleet) {
            this.fleet = fleet != null ? fleet.build() : null;
        }

        @Override
        public final Builder fleet(Fleet fleet) {
            this.fleet = fleet;
            return this;
        }

        @Override
        public UpdateFleetResponse build() {
            return new UpdateFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
