/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>GetObjectAttributes</a> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetObjectAttributesResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetObjectAttributesResponse.Builder, BatchGetObjectAttributesResponse> {
    private static final SdkField<List<AttributeKeyAndValue>> ATTRIBUTES_FIELD = SdkField
            .<List<AttributeKeyAndValue>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(BatchGetObjectAttributesResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeKeyAndValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeKeyAndValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AttributeKeyAndValue> attributes;

    private BatchGetObjectAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attribute values that are associated with an object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The attribute values that are associated with an object.
     */
    public final List<AttributeKeyAndValue> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetObjectAttributesResponse)) {
            return false;
        }
        BatchGetObjectAttributesResponse other = (BatchGetObjectAttributesResponse) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetObjectAttributesResponse").add("Attributes", hasAttributes() ? attributes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetObjectAttributesResponse, T> g) {
        return obj -> g.apply((BatchGetObjectAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetObjectAttributesResponse> {
        /**
         * <p>
         * The attribute values that are associated with an object.
         * </p>
         * 
         * @param attributes
         *        The attribute values that are associated with an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<AttributeKeyAndValue> attributes);

        /**
         * <p>
         * The attribute values that are associated with an object.
         * </p>
         * 
         * @param attributes
         *        The attribute values that are associated with an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(AttributeKeyAndValue... attributes);

        /**
         * <p>
         * The attribute values that are associated with an object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<AttributeKeyAndValue>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<AttributeKeyAndValue>)
         */
        Builder attributes(Consumer<AttributeKeyAndValue.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private List<AttributeKeyAndValue> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetObjectAttributesResponse model) {
            attributes(model.attributes);
        }

        public final List<AttributeKeyAndValue.Builder> getAttributes() {
            List<AttributeKeyAndValue.Builder> result = AttributeKeyAndValueListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<AttributeKeyAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<AttributeKeyAndValue> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeKeyAndValue... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeKeyAndValue.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> AttributeKeyAndValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetObjectAttributesResponse build() {
            return new BatchGetObjectAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
