/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent} that
 * represents the {@code ConverseStreamOutput$contentBlockStop} event. Do not use this class directly. Instead, use the
 * static builder methods on {@link software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultContentBlockStop extends ContentBlockStopEvent {
    private static final long serialVersionUID = 1L;

    DefaultContentBlockStop(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(ConverseStreamResponseHandler.Visitor visitor) {
        visitor.visitContentBlockStop(this);
    }

    @Override
    public ConverseStreamOutput.EventType sdkEventType() {
        return ConverseStreamOutput.EventType.CONTENT_BLOCK_STOP;
    }

    public interface Builder extends ContentBlockStopEvent.Builder {
        @Override
        DefaultContentBlockStop build();
    }

    private static final class BuilderImpl extends ContentBlockStopEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultContentBlockStop event) {
            super(event);
        }

        @Override
        public DefaultContentBlockStop build() {
            return new DefaultContentBlockStop(this);
        }
    }
}
