/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse;

public class ListBackupVaultsIterable
implements SdkIterable<ListBackupVaultsResponse> {
    private final BackupClient client;
    private final ListBackupVaultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackupVaultsIterable(BackupClient client, ListBackupVaultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBackupVaultsResponseFetcher();
    }

    public Iterator<ListBackupVaultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListBackupVaultsIterable resume(ListBackupVaultsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListBackupVaultsIterable(this.client, (ListBackupVaultsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListBackupVaultsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListBackupVaultsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListBackupVaultsResponseFetcher
    implements SyncPageFetcher<ListBackupVaultsResponse> {
        private ListBackupVaultsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupVaultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackupVaultsResponse nextPage(ListBackupVaultsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupVaultsIterable.this.client.listBackupVaults(ListBackupVaultsIterable.this.firstRequest);
            }
            return ListBackupVaultsIterable.this.client.listBackupVaults((ListBackupVaultsRequest)((Object)ListBackupVaultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

