/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.Index;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecoveryPointIndexSettingsRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, UpdateRecoveryPointIndexSettingsRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(UpdateRecoveryPointIndexSettingsRequest.getter(UpdateRecoveryPointIndexSettingsRequest::backupVaultName)).setter(UpdateRecoveryPointIndexSettingsRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(UpdateRecoveryPointIndexSettingsRequest.getter(UpdateRecoveryPointIndexSettingsRequest::recoveryPointArn)).setter(UpdateRecoveryPointIndexSettingsRequest.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("recoveryPointArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(UpdateRecoveryPointIndexSettingsRequest.getter(UpdateRecoveryPointIndexSettingsRequest::iamRoleArn)).setter(UpdateRecoveryPointIndexSettingsRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Index").getter(UpdateRecoveryPointIndexSettingsRequest.getter(UpdateRecoveryPointIndexSettingsRequest::indexAsString)).setter(UpdateRecoveryPointIndexSettingsRequest.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, RECOVERY_POINT_ARN_FIELD, IAM_ROLE_ARN_FIELD, INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRecoveryPointIndexSettingsRequest.memberNameToFieldInitializer();
    private final String backupVaultName;
    private final String recoveryPointArn;
    private final String iamRoleArn;
    private final String index;

    private UpdateRecoveryPointIndexSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.index = builder.index;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final Index index() {
        return Index.fromValue(this.index);
    }

    public final String indexAsString() {
        return this.index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecoveryPointIndexSettingsRequest)) {
            return false;
        }
        UpdateRecoveryPointIndexSettingsRequest other = (UpdateRecoveryPointIndexSettingsRequest)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.indexAsString(), other.indexAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecoveryPointIndexSettingsRequest").add("BackupVaultName", (Object)this.backupVaultName()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("IamRoleArn", (Object)this.iamRoleArn()).add("Index", (Object)this.indexAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.indexAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("backupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("recoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("Index", INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecoveryPointIndexSettingsRequest, T> g) {
        return obj -> g.apply((UpdateRecoveryPointIndexSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String recoveryPointArn;
        private String iamRoleArn;
        private String index;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecoveryPointIndexSettingsRequest model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.recoveryPointArn(model.recoveryPointArn);
            this.iamRoleArn(model.iamRoleArn);
            this.index(model.index);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getIndex() {
            return this.index;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        @Override
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        @Override
        public final Builder index(Index index) {
            this.index(index == null ? null : index.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecoveryPointIndexSettingsRequest build() {
            return new UpdateRecoveryPointIndexSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecoveryPointIndexSettingsRequest> {
        public Builder backupVaultName(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder iamRoleArn(String var1);

        public Builder index(String var1);

        public Builder index(Index var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

