/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.IndexStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndexedRecoveryPointsRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListIndexedRecoveryPointsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIndexedRecoveryPointsRequest.getter(ListIndexedRecoveryPointsRequest::nextToken)).setter(ListIndexedRecoveryPointsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListIndexedRecoveryPointsRequest.getter(ListIndexedRecoveryPointsRequest::maxResults)).setter(ListIndexedRecoveryPointsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceResourceArn").getter(ListIndexedRecoveryPointsRequest.getter(ListIndexedRecoveryPointsRequest::sourceResourceArn)).setter(ListIndexedRecoveryPointsRequest.setter(Builder::sourceResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sourceResourceArn").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedBefore").getter(ListIndexedRecoveryPointsRequest.getter(ListIndexedRecoveryPointsRequest::createdBefore)).setter(ListIndexedRecoveryPointsRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAfter").getter(ListIndexedRecoveryPointsRequest.getter(ListIndexedRecoveryPointsRequest::createdAfter)).setter(ListIndexedRecoveryPointsRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ListIndexedRecoveryPointsRequest.getter(ListIndexedRecoveryPointsRequest::resourceType)).setter(ListIndexedRecoveryPointsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(ListIndexedRecoveryPointsRequest.getter(ListIndexedRecoveryPointsRequest::indexStatusAsString)).setter(ListIndexedRecoveryPointsRequest.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("indexStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SOURCE_RESOURCE_ARN_FIELD, CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD, RESOURCE_TYPE_FIELD, INDEX_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIndexedRecoveryPointsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String sourceResourceArn;
    private final Instant createdBefore;
    private final Instant createdAfter;
    private final String resourceType;
    private final String indexStatus;

    private ListIndexedRecoveryPointsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
        this.resourceType = builder.resourceType;
        this.indexStatus = builder.indexStatus;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String sourceResourceArn() {
        return this.sourceResourceArn;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexedRecoveryPointsRequest)) {
            return false;
        }
        ListIndexedRecoveryPointsRequest other = (ListIndexedRecoveryPointsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sourceResourceArn(), other.sourceResourceArn()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListIndexedRecoveryPointsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SourceResourceArn", (Object)this.sourceResourceArn()).add("CreatedBefore", (Object)this.createdBefore()).add("CreatedAfter", (Object)this.createdAfter()).add("ResourceType", (Object)this.resourceType()).add("IndexStatus", (Object)this.indexStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "SourceResourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceArn()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("sourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("createdBefore", CREATED_BEFORE_FIELD);
        map.put("createdAfter", CREATED_AFTER_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("indexStatus", INDEX_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIndexedRecoveryPointsRequest, T> g) {
        return obj -> g.apply((ListIndexedRecoveryPointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String sourceResourceArn;
        private Instant createdBefore;
        private Instant createdAfter;
        private String resourceType;
        private String indexStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexedRecoveryPointsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sourceResourceArn(model.sourceResourceArn);
            this.createdBefore(model.createdBefore);
            this.createdAfter(model.createdAfter);
            this.resourceType(model.resourceType);
            this.indexStatus(model.indexStatus);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSourceResourceArn() {
            return this.sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIndexedRecoveryPointsRequest build() {
            return new ListIndexedRecoveryPointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIndexedRecoveryPointsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sourceResourceArn(String var1);

        public Builder createdBefore(Instant var1);

        public Builder createdAfter(Instant var1);

        public Builder resourceType(String var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

