/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.RestoreJobSummary;
import software.amazon.awssdk.services.backup.model.RestoreJobSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRestoreJobSummariesResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListRestoreJobSummariesResponse> {
    private static final SdkField<List<RestoreJobSummary>> RESTORE_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestoreJobSummaries").getter(ListRestoreJobSummariesResponse.getter(ListRestoreJobSummariesResponse::restoreJobSummaries)).setter(ListRestoreJobSummariesResponse.setter(Builder::restoreJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RestoreJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationPeriod").getter(ListRestoreJobSummariesResponse.getter(ListRestoreJobSummariesResponse::aggregationPeriod)).setter(ListRestoreJobSummariesResponse.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPeriod").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRestoreJobSummariesResponse.getter(ListRestoreJobSummariesResponse::nextToken)).setter(ListRestoreJobSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_JOB_SUMMARIES_FIELD, AGGREGATION_PERIOD_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRestoreJobSummariesResponse.memberNameToFieldInitializer();
    private final List<RestoreJobSummary> restoreJobSummaries;
    private final String aggregationPeriod;
    private final String nextToken;

    private ListRestoreJobSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.restoreJobSummaries = builder.restoreJobSummaries;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRestoreJobSummaries() {
        return this.restoreJobSummaries != null && !(this.restoreJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<RestoreJobSummary> restoreJobSummaries() {
        return this.restoreJobSummaries;
    }

    public final String aggregationPeriod() {
        return this.aggregationPeriod;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreJobSummaries() ? this.restoreJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreJobSummariesResponse)) {
            return false;
        }
        ListRestoreJobSummariesResponse other = (ListRestoreJobSummariesResponse)((Object)obj);
        return this.hasRestoreJobSummaries() == other.hasRestoreJobSummaries() && Objects.equals(this.restoreJobSummaries(), other.restoreJobSummaries()) && Objects.equals(this.aggregationPeriod(), other.aggregationPeriod()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRestoreJobSummariesResponse").add("RestoreJobSummaries", this.hasRestoreJobSummaries() ? this.restoreJobSummaries() : null).add("AggregationPeriod", (Object)this.aggregationPeriod()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestoreJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.restoreJobSummaries()));
            }
            case "AggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriod()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RestoreJobSummaries", RESTORE_JOB_SUMMARIES_FIELD);
        map.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreJobSummariesResponse, T> g) {
        return obj -> g.apply((ListRestoreJobSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<RestoreJobSummary> restoreJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String aggregationPeriod;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreJobSummariesResponse model) {
            super(model);
            this.restoreJobSummaries(model.restoreJobSummaries);
            this.aggregationPeriod(model.aggregationPeriod);
            this.nextToken(model.nextToken);
        }

        public final List<RestoreJobSummary.Builder> getRestoreJobSummaries() {
            List<RestoreJobSummary.Builder> result = RestoreJobSummaryListCopier.copyToBuilder(this.restoreJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreJobSummaries(Collection<RestoreJobSummary.BuilderImpl> restoreJobSummaries) {
            this.restoreJobSummaries = RestoreJobSummaryListCopier.copyFromBuilder(restoreJobSummaries);
        }

        @Override
        public final Builder restoreJobSummaries(Collection<RestoreJobSummary> restoreJobSummaries) {
            this.restoreJobSummaries = RestoreJobSummaryListCopier.copy(restoreJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreJobSummaries(RestoreJobSummary ... restoreJobSummaries) {
            this.restoreJobSummaries(Arrays.asList(restoreJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreJobSummaries(Consumer<RestoreJobSummary.Builder> ... restoreJobSummaries) {
            this.restoreJobSummaries(Stream.of(restoreJobSummaries).map(c -> (RestoreJobSummary)((RestoreJobSummary.Builder)RestoreJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRestoreJobSummariesResponse build() {
            return new ListRestoreJobSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRestoreJobSummariesResponse> {
        public Builder restoreJobSummaries(Collection<RestoreJobSummary> var1);

        public Builder restoreJobSummaries(RestoreJobSummary ... var1);

        public Builder restoreJobSummaries(Consumer<RestoreJobSummary.Builder> ... var1);

        public Builder aggregationPeriod(String var1);

        public Builder nextToken(String var1);
    }
}

