/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;

public class ListProtectedResourcesIterable
implements SdkIterable<ListProtectedResourcesResponse> {
    private final BackupClient client;
    private final ListProtectedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProtectedResourcesIterable(BackupClient client, ListProtectedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProtectedResourcesResponseFetcher();
    }

    public Iterator<ListProtectedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListProtectedResourcesIterable resume(ListProtectedResourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListProtectedResourcesIterable(this.client, (ListProtectedResourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListProtectedResourcesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListProtectedResourcesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListProtectedResourcesResponseFetcher
    implements SyncPageFetcher<ListProtectedResourcesResponse> {
        private ListProtectedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProtectedResourcesResponse nextPage(ListProtectedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedResourcesIterable.this.client.listProtectedResources(ListProtectedResourcesIterable.this.firstRequest);
            }
            return ListProtectedResourcesIterable.this.client.listProtectedResources((ListProtectedResourcesRequest)((Object)ListProtectedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

