/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.ListBackupPlansRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlansResponse;

public class ListBackupPlansPublisher
implements SdkPublisher<ListBackupPlansResponse> {
    private final BackupAsyncClient client;
    private final ListBackupPlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackupPlansPublisher(BackupAsyncClient client, ListBackupPlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackupPlansPublisher(BackupAsyncClient client, ListBackupPlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackupPlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackupPlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListBackupPlansPublisher resume(ListBackupPlansResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListBackupPlansPublisher(this.client, (ListBackupPlansRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListBackupPlansPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListBackupPlansResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListBackupPlansResponseFetcher
    implements AsyncPageFetcher<ListBackupPlansResponse> {
        private ListBackupPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackupPlansResponse> nextPage(ListBackupPlansResponse previousPage) {
            if (previousPage == null) {
                return ListBackupPlansPublisher.this.client.listBackupPlans(ListBackupPlansPublisher.this.firstRequest);
            }
            return ListBackupPlansPublisher.this.client.listBackupPlans((ListBackupPlansRequest)((Object)ListBackupPlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

