/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCopyJobResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, StartCopyJobResponse> {
    private static final SdkField<String> COPY_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartCopyJobResponse.getter(StartCopyJobResponse::copyJobId)).setter(StartCopyJobResponse.setter(Builder::copyJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJobId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StartCopyJobResponse.getter(StartCopyJobResponse::creationDate)).setter(StartCopyJobResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_JOB_ID_FIELD, CREATION_DATE_FIELD));
    private final String copyJobId;
    private final Instant creationDate;

    private StartCopyJobResponse(BuilderImpl builder) {
        super(builder);
        this.copyJobId = builder.copyJobId;
        this.creationDate = builder.creationDate;
    }

    public String copyJobId() {
        return this.copyJobId;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.copyJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCopyJobResponse)) {
            return false;
        }
        StartCopyJobResponse other = (StartCopyJobResponse)((Object)obj);
        return Objects.equals(this.copyJobId(), other.copyJobId()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"StartCopyJobResponse").add("CopyJobId", (Object)this.copyJobId()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopyJobId": {
                return Optional.ofNullable(clazz.cast(this.copyJobId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCopyJobResponse, T> g) {
        return obj -> g.apply((StartCopyJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String copyJobId;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCopyJobResponse model) {
            super(model);
            this.copyJobId(model.copyJobId);
            this.creationDate(model.creationDate);
        }

        public final String getCopyJobId() {
            return this.copyJobId;
        }

        @Override
        public final Builder copyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
            return this;
        }

        public final void setCopyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public StartCopyJobResponse build() {
            return new StartCopyJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCopyJobResponse> {
        public Builder copyJobId(String var1);

        public Builder creationDate(Instant var1);
    }
}

