/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInfoListCopier;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationsResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, ListApplicationsResponse> {
    private static final SdkField<List<ApplicationInfo>> APPLICATION_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationInfoList").getter(ListApplicationsResponse.getter(ListApplicationsResponse::applicationInfoList)).setter(ListApplicationsResponse.setter(Builder::applicationInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationsResponse.getter(ListApplicationsResponse::nextToken)).setter(ListApplicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApplicationInfo> applicationInfoList;
    private final String nextToken;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInfoList = builder.applicationInfoList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationInfoList() {
        return this.applicationInfoList != null && !(this.applicationInfoList instanceof SdkAutoConstructList);
    }

    public final List<ApplicationInfo> applicationInfoList() {
        return this.applicationInfoList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationInfoList() ? this.applicationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse)((Object)obj);
        return this.hasApplicationInfoList() == other.hasApplicationInfoList() && Objects.equals(this.applicationInfoList(), other.applicationInfoList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationsResponse").add("ApplicationInfoList", this.hasApplicationInfoList() ? this.applicationInfoList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationInfoList": {
                return Optional.ofNullable(clazz.cast(this.applicationInfoList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsResponse, T> g) {
        return obj -> g.apply((ListApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private List<ApplicationInfo> applicationInfoList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            super(model);
            this.applicationInfoList(model.applicationInfoList);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationInfo.Builder> getApplicationInfoList() {
            List<ApplicationInfo.Builder> result = ApplicationInfoListCopier.copyToBuilder(this.applicationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationInfoList(Collection<ApplicationInfo.BuilderImpl> applicationInfoList) {
            this.applicationInfoList = ApplicationInfoListCopier.copyFromBuilder(applicationInfoList);
        }

        @Override
        public final Builder applicationInfoList(Collection<ApplicationInfo> applicationInfoList) {
            this.applicationInfoList = ApplicationInfoListCopier.copy(applicationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationInfoList(ApplicationInfo ... applicationInfoList) {
            this.applicationInfoList(Arrays.asList(applicationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationInfoList(Consumer<ApplicationInfo.Builder> ... applicationInfoList) {
            this.applicationInfoList(Stream.of(applicationInfoList).map(c -> (ApplicationInfo)((ApplicationInfo.Builder)ApplicationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationsResponse> {
        public Builder applicationInfoList(Collection<ApplicationInfo> var1);

        public Builder applicationInfoList(ApplicationInfo ... var1);

        public Builder applicationInfoList(Consumer<ApplicationInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

