/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.glwallpaperservice;

import android.opengl.GLSurfaceView;
import android.util.Log;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

public class EglConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    private static final String TAG = "GLWallpaperService";
    public static final int EGL_COVERAGE_BUFFERS_NV = 12512;
    public static final int EGL_COVERAGE_SAMPLES_NV = 12513;
    protected int mRedSize;
    protected int mGreenSize;
    protected int mBlueSize;
    protected int mAlphaSize;
    protected int mDepthSize;
    protected int mStencilSize;
    protected int mNumSamples;
    protected final int[] mConfigAttribs;
    private final int[] mValue = new int[1];

    public EglConfigChooser(int r, int g, int b, int a, int depth, int stencil, int numSamples) {
        this.mRedSize = r;
        this.mGreenSize = g;
        this.mBlueSize = b;
        this.mAlphaSize = a;
        this.mDepthSize = depth;
        this.mStencilSize = stencil;
        this.mNumSamples = numSamples;
        this.mConfigAttribs = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 64, 12344};
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
        int[] num_config = new int[1];
        egl.eglChooseConfig(display, this.mConfigAttribs, null, 0, num_config);
        int numConfigs = num_config[0];
        if (numConfigs <= 0) {
            throw new IllegalArgumentException("No configs match configSpec");
        }
        EGLConfig[] configs = new EGLConfig[numConfigs];
        egl.eglChooseConfig(display, this.mConfigAttribs, configs, numConfigs, num_config);
        EGLConfig config = this.chooseConfig(egl, display, configs);
        this.printConfig(egl, display, config);
        return config;
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
        EGLConfig best = null;
        EGLConfig bestAA = null;
        EGLConfig safe = null;
        for (EGLConfig config : configs) {
            int d = this.findConfigAttrib(egl, display, config, 12325, 0);
            int s = this.findConfigAttrib(egl, display, config, 12326, 0);
            if (d < this.mDepthSize || s < this.mStencilSize) continue;
            int r = this.findConfigAttrib(egl, display, config, 12324, 0);
            int g = this.findConfigAttrib(egl, display, config, 12323, 0);
            int b = this.findConfigAttrib(egl, display, config, 12322, 0);
            int a = this.findConfigAttrib(egl, display, config, 12321, 0);
            if (safe == null && r == 5 && g == 6 && b == 5 && a == 0) {
                safe = config;
            }
            if (best == null && r == this.mRedSize && g == this.mGreenSize && b == this.mBlueSize && a == this.mAlphaSize) {
                best = config;
                if (this.mNumSamples == 0) break;
            }
            int hasSampleBuffers = this.findConfigAttrib(egl, display, config, 12338, 0);
            int numSamples = this.findConfigAttrib(egl, display, config, 12337, 0);
            if (bestAA == null && hasSampleBuffers == 1 && numSamples >= this.mNumSamples && r == this.mRedSize && g == this.mGreenSize && b == this.mBlueSize && a == this.mAlphaSize) {
                bestAA = config;
                continue;
            }
            hasSampleBuffers = this.findConfigAttrib(egl, display, config, 12512, 0);
            numSamples = this.findConfigAttrib(egl, display, config, 12513, 0);
            if (bestAA != null || hasSampleBuffers != 1 || numSamples < this.mNumSamples || r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
            bestAA = config;
        }
        if (bestAA != null) {
            return bestAA;
        }
        if (best != null) {
            return best;
        }
        return safe;
    }

    private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
        if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
            return this.mValue[0];
        }
        return defaultValue;
    }

    private void printConfig(EGL10 egl, EGLDisplay display, EGLConfig config) {
        int[] attributes = new int[]{12320, 12324, 12323, 12322, 12321, 12325, 12326, 12337, 12338, 12512, 12513};
        String[] names = new String[]{"EGL_BUFFER_SIZE", "EGL_RED_SIZE", "EGL_GREEN_SIZE", "EGL_BLUE_SIZE", "EGL_ALPHA_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_COVERAGE_BUFFERS_NV", "EGL_COVERAGE_SAMPLES_NV"};
        Log.d((String)TAG, (String)"chooseConfig:");
        int[] value = new int[1];
        for (int i = 0; i < attributes.length; ++i) {
            int attribute = attributes[i];
            String name = names[i];
            if (egl.eglGetConfigAttrib(display, config, attribute, value)) {
                Log.d((String)TAG, (String)String.format("%s: %d", name, value[0]));
                continue;
            }
            egl.eglGetError();
        }
    }
}

