/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.glwallpaperservice;

import android.opengl.GLDebugHelper;
import android.service.wallpaper.WallpaperService;
import android.util.Log;
import android.view.SurfaceHolder;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLWallpaperService
extends WallpaperService {
    private static final String TAG = "GLWallpaperService";
    private static final boolean LOG_THREADS = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_EGL = false;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();

    public WallpaperService.Engine onCreateEngine() {
        return null;
    }

    public static String getErrorString(int error) {
        switch (error) {
            case 12288: {
                return "EGL_SUCCESS";
            }
            case 12289: {
                return "EGL_NOT_INITIALIZED";
            }
            case 12290: {
                return "EGL_BAD_ACCESS";
            }
            case 12291: {
                return "EGL_BAD_ALLOC";
            }
            case 12292: {
                return "EGL_BAD_ATTRIBUTE";
            }
            case 12293: {
                return "EGL_BAD_CONFIG";
            }
            case 12294: {
                return "EGL_BAD_CONTEXT";
            }
            case 12295: {
                return "EGL_BAD_CURRENT_SURFACE";
            }
            case 12296: {
                return "EGL_BAD_DISPLAY";
            }
            case 12297: {
                return "EGL_BAD_MATCH";
            }
            case 12298: {
                return "EGL_BAD_NATIVE_PIXMAP";
            }
            case 12299: {
                return "EGL_BAD_NATIVE_WINDOW";
            }
            case 12300: {
                return "EGL_BAD_PARAMETER";
            }
            case 12301: {
                return "EGL_BAD_SURFACE";
            }
            case 12302: {
                return "EGL_CONTEXT_LOST";
            }
        }
        return GLWallpaperService.getHex(error);
    }

    private static String getHex(int value) {
        return "0x" + Integer.toHexString(value);
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] buf, int offset, int count) {
            for (int i = 0; i < count; ++i) {
                char c = buf[offset + i];
                if (c == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c);
            }
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v((String)"GLSurfaceView", (String)this.mBuilder.toString());
                this.mBuilder.delete(0, this.mBuilder.length());
            }
        }
    }

    private static class EglHelper {
        private WeakReference<GLEngine> mGLEngineWeakReference;
        EGL10 mEgl;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;

        public EglHelper(WeakReference<GLEngine> glEngineWeakReference) {
            this.mGLEngineWeakReference = glEngineWeakReference;
        }

        public void start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] version = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
                throw new RuntimeException("eglInitialize failed");
            }
            GLEngine view = (GLEngine)((Object)this.mGLEngineWeakReference.get());
            if (view == null) {
                this.mEglConfig = null;
                this.mEglContext = null;
            } else {
                this.mEglConfig = view.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                this.mEglContext = view.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
            }
            if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                this.mEglContext = null;
                this.throwEglException("createContext");
            }
            this.mEglSurface = null;
        }

        public boolean createSurface() {
            if (this.mEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.mEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.mEglConfig == null) {
                throw new RuntimeException("mEglConfig not initialized");
            }
            this.destroySurfaceImp();
            GLEngine view = (GLEngine)((Object)this.mGLEngineWeakReference.get());
            this.mEglSurface = view != null ? view.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, view.getSurfaceHolder()) : null;
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int error = this.mEgl.eglGetError();
                if (error == 12299) {
                    Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                return false;
            }
            return true;
        }

        GL createGL() {
            GL gl = this.mEglContext.getGL();
            GLEngine view = (GLEngine)((Object)this.mGLEngineWeakReference.get());
            if (view != null) {
                if (view.mGLWrapper != null) {
                    gl = view.mGLWrapper.wrap(gl);
                }
                if ((view.mDebugFlags & 3) != 0) {
                    int configFlags = 0;
                    LogWriter log = null;
                    if ((view.mDebugFlags & 1) != 0) {
                        configFlags |= 1;
                    }
                    if ((view.mDebugFlags & 2) != 0) {
                        log = new LogWriter();
                    }
                    gl = GLDebugHelper.wrap((GL)gl, (int)configFlags, (Writer)log);
                }
            }
            return gl;
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        private void destroySurfaceImp() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLEngine view = (GLEngine)((Object)this.mGLEngineWeakReference.get());
                if (view != null) {
                    view.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public void finish() {
            if (this.mEglContext != null) {
                GLEngine view = (GLEngine)((Object)this.mGLEngineWeakReference.get());
                if (view != null) {
                    view.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        private void throwEglException(String function) {
            EglHelper.throwEglException(function, this.mEgl.eglGetError());
        }

        public static void throwEglException(String function, int error) {
            String message = EglHelper.formatEglError(function, error);
            throw new RuntimeException(message);
        }

        public static void logEglErrorAsWarning(String tag, String function, int error) {
            Log.w((String)tag, (String)EglHelper.formatEglError(function, error));
        }

        public static String formatEglError(String function, int error) {
            return function + " failed: " + GLWallpaperService.getErrorString(error);
        }
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";

        private GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread thread) {
            thread.mExited = true;
            this.notifyAll();
        }

        public void releaseEglContextLocked(GLThread thread) {
            this.notifyAll();
        }
    }

    static class GLThread
    extends Thread {
        private boolean mShouldExit;
        private boolean mExited;
        private boolean mRequestPaused;
        private boolean mPaused;
        private boolean mHasSurface;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private boolean mFinishedCreatingEglSurface;
        private boolean mShouldReleaseEglContext;
        private int mWidth = 0;
        private int mHeight = 0;
        private int mRenderMode = 1;
        private boolean mRequestRender = true;
        private boolean mWantRenderNotification = false;
        private boolean mRenderComplete;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private boolean mSizeChanged = true;
        private Runnable mFinishDrawingRunnable = null;
        private EglHelper mEglHelper;
        private WeakReference<GLEngine> mGLEngineWeakReference;

        GLThread(WeakReference<GLEngine> glEngineWeakReference) {
            this.mGLEngineWeakReference = glEngineWeakReference;
        }

        @Override
        public void run() {
            this.setName("GLThread " + this.getId());
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                sGLThreadManager.threadExiting(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper(this.mGLEngineWeakReference);
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            this.mWantRenderNotification = false;
            try {
                gl = null;
                createEglContext = false;
                createEglSurface = false;
                createGlInterface = false;
                lostEglContext = false;
                sizeChanged = false;
                wantRenderNotification = false;
                doRenderNotification = false;
                askedToReleaseEglContext = false;
                w = 0;
                h = 0;
                event = null;
                finishDrawingRunnable = null;
                while (true) {
                    var14_14 = GLWallpaperService.access$400();
                    synchronized (var14_14) {
                        while (true) {
                            if (this.mShouldExit) {
                                return;
                            }
                            if (!this.mEventQueue.isEmpty()) {
                                event = this.mEventQueue.remove(0);
                                break;
                            }
                            pausing = false;
                            if (this.mPaused != this.mRequestPaused) {
                                pausing = this.mRequestPaused;
                                this.mPaused = this.mRequestPaused;
                                GLWallpaperService.access$400().notifyAll();
                            }
                            if (this.mShouldReleaseEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                this.mShouldReleaseEglContext = false;
                                askedToReleaseEglContext = true;
                            }
                            if (lostEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                lostEglContext = false;
                            }
                            if (pausing && this.mHaveEglSurface) {
                                this.stopEglSurfaceLocked();
                            }
                            if (pausing && this.mHaveEglContext) {
                                view = (GLEngine)this.mGLEngineWeakReference.get();
                                v0 = preserveEglContextOnPause = view == null ? false : GLEngine.access$500(view);
                                if (!preserveEglContextOnPause) {
                                    this.stopEglContextLocked();
                                }
                            }
                            if (!this.mHasSurface && !this.mWaitingForSurface) {
                                if (this.mHaveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                this.mWaitingForSurface = true;
                                this.mSurfaceIsBad = false;
                                GLWallpaperService.access$400().notifyAll();
                            }
                            if (this.mHasSurface && this.mWaitingForSurface) {
                                this.mWaitingForSurface = false;
                                GLWallpaperService.access$400().notifyAll();
                            }
                            if (doRenderNotification) {
                                this.mWantRenderNotification = false;
                                doRenderNotification = false;
                                this.mRenderComplete = true;
                                GLWallpaperService.access$400().notifyAll();
                            }
                            if (this.mFinishDrawingRunnable != null) {
                                finishDrawingRunnable = this.mFinishDrawingRunnable;
                                this.mFinishDrawingRunnable = null;
                            }
                            if (this.readyToDraw()) {
                                if (!this.mHaveEglContext) {
                                    if (askedToReleaseEglContext) {
                                        askedToReleaseEglContext = false;
                                    } else {
                                        try {
                                            this.mEglHelper.start();
                                        }
                                        catch (RuntimeException t) {
                                            GLWallpaperService.access$400().releaseEglContextLocked(this);
                                            throw t;
                                        }
                                        this.mHaveEglContext = true;
                                        createEglContext = true;
                                        GLWallpaperService.access$400().notifyAll();
                                    }
                                }
                                if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                    this.mHaveEglSurface = true;
                                    createEglSurface = true;
                                    createGlInterface = true;
                                    sizeChanged = true;
                                }
                                if (this.mHaveEglSurface) {
                                    if (this.mSizeChanged) {
                                        sizeChanged = true;
                                        w = this.mWidth;
                                        h = this.mHeight;
                                        this.mWantRenderNotification = true;
                                        createEglSurface = true;
                                        this.mSizeChanged = false;
                                    }
                                    this.mRequestRender = false;
                                    GLWallpaperService.access$400().notifyAll();
                                    if (!this.mWantRenderNotification) break;
                                    wantRenderNotification = true;
                                    break;
                                }
                            } else if (finishDrawingRunnable != null) {
                                Log.w((String)"GLWallpaperService", (String)"Warning, !readyToDraw() but waiting for draw finished! Early reporting draw finished.");
                                finishDrawingRunnable.run();
                                finishDrawingRunnable = null;
                            }
                            GLWallpaperService.access$400().wait();
                        }
                        ** if (event == null) goto lbl110
                    }
lbl-1000:
                    // 1 sources

                    {
                        event.run();
                        event = null;
                        continue;
                    }
lbl110:
                    // 1 sources

                    if (createEglSurface) {
                        if (this.mEglHelper.createSurface()) {
                            var14_14 = GLWallpaperService.access$400();
                            synchronized (var14_14) {
                                this.mFinishedCreatingEglSurface = true;
                                GLWallpaperService.access$400().notifyAll();
                            }
                            createEglSurface = false;
                        } else {
                            var14_14 = GLWallpaperService.access$400();
                            synchronized (var14_14) {
                                this.mFinishedCreatingEglSurface = true;
                                this.mSurfaceIsBad = true;
                                GLWallpaperService.access$400().notifyAll();
                                continue;
                            }
                        }
                    }
                    if (createGlInterface) {
                        gl = (GL10)this.mEglHelper.createGL();
                        createGlInterface = false;
                    }
                    if (createEglContext) {
                        view = (GLEngine)this.mGLEngineWeakReference.get();
                        if (view != null) {
                            GLEngine.access$600(view).onSurfaceCreated(gl, this.mEglHelper.mEglConfig);
                        }
                        createEglContext = false;
                    }
                    if (sizeChanged) {
                        view = (GLEngine)this.mGLEngineWeakReference.get();
                        if (view != null) {
                            GLEngine.access$600(view).onSurfaceChanged(gl, w, h);
                        }
                        sizeChanged = false;
                    }
                    if ((view = (GLEngine)this.mGLEngineWeakReference.get()) != null) {
                        GLEngine.access$600(view).onDrawFrame(gl);
                        if (finishDrawingRunnable != null) {
                            finishDrawingRunnable.run();
                            finishDrawingRunnable = null;
                        }
                    }
                    swapError = this.mEglHelper.swap();
                    switch (swapError) {
                        case 12288: {
                            break;
                        }
                        case 12302: {
                            lostEglContext = true;
                            break;
                        }
                        default: {
                            EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", swapError);
                            var15_18 = GLWallpaperService.access$400();
                            synchronized (var15_18) {
                                this.mSurfaceIsBad = true;
                                GLWallpaperService.access$400().notifyAll();
                                break;
                            }
                        }
                    }
                    if (!wantRenderNotification) continue;
                    doRenderNotification = true;
                    wantRenderNotification = false;
                }
            }
            finally {
                var15_16 = GLWallpaperService.access$400();
                synchronized (var15_16) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                }
            }
        }

        public boolean ableToDraw() {
            return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
        }

        private boolean readyToDraw() {
            return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int renderMode) {
            if (0 > renderMode || renderMode > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = renderMode;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRenderAndNotify(Runnable finishDrawing) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                if (Thread.currentThread() == this) {
                    return;
                }
                this.mWantRenderNotification = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                this.mFinishDrawingRunnable = finishDrawing;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                this.mFinishedCreatingEglSurface = false;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface && !this.mFinishedCreatingEglSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && this.mPaused && !this.mRenderComplete) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int w, int h) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = w;
                this.mHeight = h;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                if (Thread.currentThread() == this) {
                    return;
                }
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable r) {
            if (r == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEventQueue.add(r);
                sGLThreadManager.notifyAll();
            }
        }
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            EGLSurface result = null;
            try {
                result = egl.eglCreateWindowSurface(display, config, nativeWindow, null);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)GLWallpaperService.TAG, (String)"eglCreateWindowSurface", (Throwable)e);
            }
            return result;
        }

        @Override
        public void destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }

    public class GLEngine
    extends WallpaperService.Engine {
        private final WeakReference<GLEngine> mThisWeakRef;
        private GLThread mGLThread;
        private Renderer mRenderer;
        private EGLConfigChooser mEGLConfigChooser;
        private EGLContextFactory mEGLContextFactory;
        private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
        private GLWrapper mGLWrapper;
        private int mDebugFlags;
        private int mEGLContextClientVersion;
        private boolean mPreserveEGLContextOnPause;

        public GLEngine() {
            super((WallpaperService)GLWallpaperService.this);
            this.mThisWeakRef = new WeakReference<GLEngine>(this);
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mGLThread != null) {
                    this.mGLThread.requestExitAndWait();
                }
            }
            finally {
                super.finalize();
            }
        }

        public void setGLWrapper(GLWrapper glWrapper) {
            this.mGLWrapper = glWrapper;
        }

        public void setDebugFlags(int debugFlags) {
            this.mDebugFlags = debugFlags;
        }

        public int getDebugFlags() {
            return this.mDebugFlags;
        }

        public void setPreserveEGLContextOnPause(boolean preserveOnPause) {
            this.mPreserveEGLContextOnPause = preserveOnPause;
        }

        public boolean getPreserveEGLContextOnPause() {
            return this.mPreserveEGLContextOnPause;
        }

        public void setRenderer(Renderer renderer) {
            this.checkRenderThreadState();
            if (this.mEGLConfigChooser == null) {
                this.mEGLConfigChooser = new SimpleEGLConfigChooser(true);
            }
            if (this.mEGLContextFactory == null) {
                this.mEGLContextFactory = new DefaultContextFactory();
            }
            if (this.mEGLWindowSurfaceFactory == null) {
                this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
            }
            this.mRenderer = renderer;
            this.mGLThread = new GLThread(this.mThisWeakRef);
            this.mGLThread.start();
        }

        public void setEGLContextFactory(EGLContextFactory factory) {
            this.checkRenderThreadState();
            this.mEGLContextFactory = factory;
        }

        public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory factory) {
            this.checkRenderThreadState();
            this.mEGLWindowSurfaceFactory = factory;
        }

        public void setEGLConfigChooser(EGLConfigChooser configChooser) {
            this.checkRenderThreadState();
            this.mEGLConfigChooser = configChooser;
        }

        public void setEGLConfigChooser(boolean needDepth) {
            this.setEGLConfigChooser(new SimpleEGLConfigChooser(needDepth));
        }

        public void setEGLConfigChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            this.setEGLConfigChooser(new ComponentSizeChooser(redSize, greenSize, blueSize, alphaSize, depthSize, stencilSize));
        }

        public void setEGLContextClientVersion(int version) {
            this.checkRenderThreadState();
            this.mEGLContextClientVersion = version;
        }

        public void setRenderMode(int renderMode) {
            this.mGLThread.setRenderMode(renderMode);
        }

        public int getRenderMode() {
            return this.mGLThread.getRenderMode();
        }

        public void requestRender() {
            this.mGLThread.requestRender();
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            super.onSurfaceCreated(holder);
            this.mGLThread.surfaceCreated();
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            super.onSurfaceDestroyed(holder);
            this.mGLThread.surfaceDestroyed();
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            super.onSurfaceChanged(holder, format, width, height);
            this.mGLThread.onWindowResize(width, height);
        }

        public void onSurfaceRedrawNeeded(SurfaceHolder holder) {
            super.onSurfaceRedrawNeeded(holder);
            if (this.mGLThread != null) {
                this.mGLThread.requestRender();
            }
        }

        public void surfaceRedrawNeededAsync(SurfaceHolder holder, Runnable finishDrawing) {
            if (this.mGLThread != null) {
                this.mGLThread.requestRenderAndNotify(finishDrawing);
            }
        }

        public void onPause() {
            this.mGLThread.onPause();
        }

        public void onResume() {
            this.mGLThread.onResume();
        }

        public void queueEvent(Runnable r) {
            this.mGLThread.queueEvent(r);
        }

        private void checkRenderThreadState() {
            if (this.mGLThread != null) {
                throw new IllegalStateException("setRenderer has already been called for this instance.");
            }
        }

        static /* synthetic */ boolean access$500(GLEngine x0) {
            return x0.mPreserveEGLContextOnPause;
        }

        static /* synthetic */ Renderer access$600(GLEngine x0) {
            return x0.mRenderer;
        }

        private class SimpleEGLConfigChooser
        extends ComponentSizeChooser {
            public SimpleEGLConfigChooser(boolean withDepthBuffer) {
                super(8, 8, 8, 0, withDepthBuffer ? 16 : 0, 0);
            }
        }

        private class ComponentSizeChooser
        extends BaseConfigChooser {
            private int[] mValue;
            protected int mRedSize;
            protected int mGreenSize;
            protected int mBlueSize;
            protected int mAlphaSize;
            protected int mDepthSize;
            protected int mStencilSize;

            public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
                super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344});
                this.mValue = new int[1];
                this.mRedSize = redSize;
                this.mGreenSize = greenSize;
                this.mBlueSize = blueSize;
                this.mAlphaSize = alphaSize;
                this.mDepthSize = depthSize;
                this.mStencilSize = stencilSize;
            }

            @Override
            public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
                for (EGLConfig config : configs) {
                    int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                    int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                    if (d < this.mDepthSize || s < this.mStencilSize) continue;
                    int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                    int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                    int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                    int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                    if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                    return config;
                }
                return null;
            }

            private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
                if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                    return this.mValue[0];
                }
                return defaultValue;
            }
        }

        private abstract class BaseConfigChooser
        implements EGLConfigChooser {
            protected int[] mConfigSpec;

            public BaseConfigChooser(int[] configSpec) {
                this.mConfigSpec = this.filterConfigSpec(configSpec);
            }

            @Override
            public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
                int[] num_config = new int[1];
                if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                    throw new IllegalArgumentException("eglChooseConfig failed");
                }
                int numConfigs = num_config[0];
                if (numConfigs <= 0) {
                    throw new IllegalArgumentException("No configs match configSpec");
                }
                EGLConfig[] configs = new EGLConfig[numConfigs];
                if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config)) {
                    throw new IllegalArgumentException("eglChooseConfig#2 failed");
                }
                EGLConfig config = this.chooseConfig(egl, display, configs);
                if (config == null) {
                    throw new IllegalArgumentException("No config chosen");
                }
                return config;
            }

            abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

            private int[] filterConfigSpec(int[] configSpec) {
                if (GLEngine.this.mEGLContextClientVersion != 2 && GLEngine.this.mEGLContextClientVersion != 3) {
                    return configSpec;
                }
                int len = configSpec.length;
                int[] newConfigSpec = new int[len + 2];
                System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
                newConfigSpec[len - 1] = 12352;
                newConfigSpec[len] = GLEngine.this.mEGLContextClientVersion == 2 ? 4 : 64;
                newConfigSpec[len + 1] = 12344;
                return newConfigSpec;
            }
        }

        private class DefaultContextFactory
        implements EGLContextFactory {
            private int EGL_CONTEXT_CLIENT_VERSION = 12440;

            private DefaultContextFactory() {
            }

            @Override
            public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
                int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, GLEngine.this.mEGLContextClientVersion, 12344};
                return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, (int[])(GLEngine.this.mEGLContextClientVersion != 0 ? attrib_list : null));
            }

            @Override
            public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
                if (!egl.eglDestroyContext(display, context)) {
                    Log.e((String)"DefaultContextFactory", (String)("display:" + display + " context: " + context));
                    EglHelper.throwEglException("eglDestroyContex", egl.eglGetError());
                }
            }
        }
    }
}

