/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import site.hanschen.easyloader.request.Request;

public class BitmapUtils {
    public static int getBitmapBytes(Bitmap bitmap) {
        int result = Build.VERSION.SDK_INT >= 19 ? bitmap.getAllocationByteCount() : (Build.VERSION.SDK_INT >= 12 ? bitmap.getByteCount() : bitmap.getRowBytes() * bitmap.getHeight());
        if (result < 0) {
            throw new IllegalStateException("Negative size: " + bitmap);
        }
        return result;
    }

    public static BitmapFactory.Options createBitmapOptions(Request data) {
        boolean justBounds = data.hasSize();
        boolean hasConfig = data.config != null;
        BitmapFactory.Options options = null;
        if (justBounds || hasConfig || data.purgeable) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = justBounds;
            options.inInputShareable = data.purgeable;
            options.inPurgeable = data.purgeable;
            if (hasConfig) {
                options.inPreferredConfig = data.config;
            }
        }
        return options;
    }

    public static boolean requiresInSampleSize(BitmapFactory.Options options) {
        return options != null && options.inJustDecodeBounds;
    }

    public static void calculateInSampleSize(int reqWidth, int reqHeight, BitmapFactory.Options options, Request request) {
        BitmapUtils.calculateInSampleSize(reqWidth, reqHeight, options.outWidth, options.outHeight, options, request);
    }

    public static void calculateInSampleSize(int reqWidth, int reqHeight, int width, int height, BitmapFactory.Options options, Request request) {
        int sampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            if (reqHeight == 0) {
                sampleSize = (int)Math.floor((float)width / (float)reqWidth);
            } else if (reqWidth == 0) {
                sampleSize = (int)Math.floor((float)height / (float)reqHeight);
            } else {
                int heightRatio = (int)Math.floor((float)height / (float)reqHeight);
                int widthRatio = (int)Math.floor((float)width / (float)reqWidth);
                sampleSize = request.centerInside ? Math.max(heightRatio, widthRatio) : Math.min(heightRatio, widthRatio);
            }
        }
        options.inSampleSize = sampleSize;
        options.inJustDecodeBounds = false;
    }
}

