/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.request;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.request.RequestHandler;
import site.hanschen.easyloader.request.Result;
import site.hanschen.easyloader.util.BitmapUtils;

public class ResourceRequestHandler
extends RequestHandler {
    private final Context context;

    public ResourceRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request request) {
        return request.resourceId != 0 || "android.resource".equals(request.uri.getScheme());
    }

    @Override
    public Result handle(Request request) throws IOException {
        Resources res = ResourceRequestHandler.getResources(this.context, request);
        int id = ResourceRequestHandler.getResourceId(res, request);
        return new Result(ResourceRequestHandler.decodeResource(res, id, request), LoadedFrom.DISK);
    }

    private static Bitmap decodeResource(Resources resources, int id, Request data) {
        BitmapFactory.Options options = BitmapUtils.createBitmapOptions(data);
        if (BitmapUtils.requiresInSampleSize(options)) {
            BitmapFactory.decodeResource((Resources)resources, (int)id, (BitmapFactory.Options)options);
            BitmapUtils.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)id, (BitmapFactory.Options)options);
    }

    private static int getResourceId(Resources resources, Request data) throws FileNotFoundException {
        int id;
        if (data.resourceId != 0 || data.uri == null) {
            return data.resourceId;
        }
        String pkg = data.uri.getAuthority();
        if (pkg == null) {
            throw new FileNotFoundException("No package provided: " + data.uri);
        }
        List segments = data.uri.getPathSegments();
        if (segments == null || segments.isEmpty()) {
            throw new FileNotFoundException("No path segments: " + data.uri);
        }
        if (segments.size() == 1) {
            try {
                id = Integer.parseInt((String)segments.get(0));
            }
            catch (NumberFormatException e) {
                throw new FileNotFoundException("Last path segment is not a resource ID: " + data.uri);
            }
        } else if (segments.size() == 2) {
            String type = (String)segments.get(0);
            String name = (String)segments.get(1);
            id = resources.getIdentifier(name, type, pkg);
        } else {
            throw new FileNotFoundException("More than two path segments: " + data.uri);
        }
        return id;
    }

    private static Resources getResources(Context context, Request data) throws FileNotFoundException {
        if (data.resourceId != 0 || data.uri == null) {
            return context.getResources();
        }
        String pkg = data.uri.getAuthority();
        if (pkg == null) {
            throw new FileNotFoundException("No package provided: " + data.uri);
        }
        try {
            PackageManager pm = context.getPackageManager();
            return pm.getResourcesForApplication(pkg);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new FileNotFoundException("Unable to obtain resources for package: " + data.uri);
        }
    }
}

