/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.request;

import android.app.Notification;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import android.widget.RemoteViews;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import site.hanschen.easyloader.BitmapHunter;
import site.hanschen.easyloader.Callback;
import site.hanschen.easyloader.DeferredRequestCreator;
import site.hanschen.easyloader.DiskPolicy;
import site.hanschen.easyloader.Dispatcher;
import site.hanschen.easyloader.EasyLoader;
import site.hanschen.easyloader.EnhanceDrawable;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.MemoryPolicy;
import site.hanschen.easyloader.Priority;
import site.hanschen.easyloader.Target;
import site.hanschen.easyloader.Transformation;
import site.hanschen.easyloader.action.FetchAction;
import site.hanschen.easyloader.action.GetAction;
import site.hanschen.easyloader.action.ImageViewAction;
import site.hanschen.easyloader.action.RemoteViewsAction;
import site.hanschen.easyloader.action.TargetAction;
import site.hanschen.easyloader.log.EasyLoaderLog;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.request.RequestTransformer;
import site.hanschen.easyloader.util.ThreadChecker;
import site.hanschen.easyloader.util.Utils;

public class RequestCreator {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final EasyLoader loader;
    private final RequestTransformer requestTransformer;
    private final Dispatcher dispatcher;
    private final Request.Builder builder;
    private boolean noFade;
    private boolean deferred;
    private boolean setPlaceholder = true;
    private int placeholderResId;
    private int errorResId;
    private int memoryPolicy;
    private int diskPolicy;
    private Drawable placeholderDrawable;
    private Drawable errorDrawable;
    private Object tag;

    public RequestCreator(EasyLoader loader, Uri uri, int resourceId, RequestTransformer requestTransformer, Dispatcher dispatcher) {
        if (loader.isShutdown()) {
            throw new IllegalStateException("EasyLoader instance already shut down. Cannot submit new requests.");
        }
        if (uri != null == (resourceId != 0)) {
            throw new IllegalArgumentException("uri and resourceId can not both be null or not null");
        }
        this.requestTransformer = requestTransformer;
        this.loader = loader;
        this.dispatcher = dispatcher;
        this.builder = new Request.Builder(uri, resourceId, loader.getDefaultBitmapConfig());
    }

    public RequestCreator noPlaceholder() {
        if (this.placeholderResId != 0) {
            throw new IllegalStateException("Placeholder resource already set.");
        }
        if (this.placeholderDrawable != null) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.setPlaceholder = false;
        return this;
    }

    public RequestCreator placeholder(int placeholderResId) {
        if (!this.setPlaceholder) {
            throw new IllegalStateException("Already explicitly declared as no placeholder.");
        }
        if (placeholderResId == 0) {
            throw new IllegalArgumentException("Placeholder image resource invalid.");
        }
        if (this.placeholderDrawable != null) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderResId = placeholderResId;
        return this;
    }

    public RequestCreator placeholder(Drawable placeholderDrawable) {
        if (!this.setPlaceholder) {
            throw new IllegalStateException("Already explicitly declared as no placeholder.");
        }
        if (this.placeholderResId != 0) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderDrawable = placeholderDrawable;
        return this;
    }

    public RequestCreator error(int errorResId) {
        if (errorResId == 0) {
            throw new IllegalArgumentException("Error image resource invalid.");
        }
        if (this.errorDrawable != null) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorResId = errorResId;
        return this;
    }

    public RequestCreator error(Drawable errorDrawable) {
        if (errorDrawable == null) {
            throw new IllegalArgumentException("Error image may not be null.");
        }
        if (this.errorResId != 0) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorDrawable = errorDrawable;
        return this;
    }

    public RequestCreator tag(Object tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag invalid.");
        }
        if (this.tag != null) {
            throw new IllegalStateException("Tag already set.");
        }
        this.tag = tag;
        return this;
    }

    public RequestCreator clearTag() {
        this.tag = null;
        return this;
    }

    public Object getTag() {
        return this.tag;
    }

    public RequestCreator fit() {
        throw new UnsupportedOperationException("fit is not support now");
    }

    public RequestCreator unfit() {
        this.deferred = false;
        return this;
    }

    public RequestCreator resizeDimen(int targetWidthResId, int targetHeightResId) {
        Resources resources = this.loader.getContext().getResources();
        int targetWidth = resources.getDimensionPixelSize(targetWidthResId);
        int targetHeight = resources.getDimensionPixelSize(targetHeightResId);
        return this.resize(targetWidth, targetHeight);
    }

    public RequestCreator resize(int targetWidth, int targetHeight) {
        this.builder.resize(targetWidth, targetHeight);
        return this;
    }

    public RequestCreator centerCrop() {
        this.builder.centerCrop();
        return this;
    }

    public RequestCreator centerInside() {
        this.builder.centerInside();
        return this;
    }

    public RequestCreator onlyScaleDown() {
        this.builder.onlyScaleDown();
        return this;
    }

    public RequestCreator rotate(float degrees) {
        this.builder.rotate(degrees);
        return this;
    }

    public RequestCreator rotate(float degrees, float pivotX, float pivotY) {
        this.builder.rotate(degrees, pivotX, pivotY);
        return this;
    }

    public RequestCreator config(Bitmap.Config config) {
        this.builder.config(config);
        return this;
    }

    public RequestCreator stableKey(String stableKey) {
        this.builder.stableKey(stableKey);
        return this;
    }

    public RequestCreator priority(Priority priority) {
        this.builder.priority(priority);
        return this;
    }

    public RequestCreator transform(Transformation transformation) {
        this.builder.transform(transformation);
        return this;
    }

    public RequestCreator transform(List<? extends Transformation> transformations) {
        this.builder.transform(transformations);
        return this;
    }

    public RequestCreator memoryPolicy(MemoryPolicy policy, MemoryPolicy ... additional) {
        if (policy == null) {
            throw new IllegalArgumentException("Memory policy cannot be null.");
        }
        this.memoryPolicy |= policy.index;
        if (additional == null) {
            throw new IllegalArgumentException("Memory policy cannot be null.");
        }
        for (MemoryPolicy memoryPolicy : additional) {
            if (memoryPolicy == null) {
                throw new IllegalArgumentException("Memory policy cannot be null.");
            }
            this.memoryPolicy |= memoryPolicy.index;
        }
        return this;
    }

    public RequestCreator diskPolicy(DiskPolicy policy, DiskPolicy ... additional) {
        if (policy == null) {
            throw new IllegalArgumentException("Network policy cannot be null.");
        }
        this.diskPolicy |= policy.index;
        if (additional == null) {
            throw new IllegalArgumentException("Network policy cannot be null.");
        }
        for (DiskPolicy diskPolicy : additional) {
            if (diskPolicy == null) {
                throw new IllegalArgumentException("Network policy cannot be null.");
            }
            this.diskPolicy |= diskPolicy.index;
        }
        return this;
    }

    public RequestCreator purgeable() {
        this.builder.purgeable();
        return this;
    }

    public RequestCreator noFade() {
        this.noFade = true;
        return this;
    }

    public Bitmap get() throws IOException {
        ThreadChecker.checkNotMain();
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with get.");
        }
        if (!this.builder.hasImage()) {
            return null;
        }
        long started = System.nanoTime();
        Request finalRequest = this.createRequest(started);
        String key = Utils.createKey(finalRequest, new StringBuilder());
        GetAction action = new GetAction(this.loader, finalRequest, this.memoryPolicy, this.diskPolicy, this.tag, key);
        return BitmapHunter.forRequest(this.loader, this.dispatcher, this.loader.getMemoryCacheManager(), this.loader.getDiskCacheManager(), action).hunt();
    }

    public void fetch() {
        this.fetch(null);
    }

    public void fetch(Callback callback) {
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with fetch.");
        }
        if (this.builder.hasImage()) {
            if (!this.builder.hasPriority()) {
                this.builder.priority(Priority.LOW);
            }
            long started = System.nanoTime();
            Request finalRequest = this.createRequest(started);
            String key = Utils.createKey(finalRequest, new StringBuilder());
            FetchAction action = new FetchAction(this.loader, finalRequest, this.memoryPolicy, this.diskPolicy, this.tag, key, callback);
            this.loader.submit(action);
        }
    }

    public void into(Target target) {
        Bitmap bitmap;
        ThreadChecker.checkMain();
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with a Target.");
        }
        if (!this.builder.hasImage()) {
            this.loader.cancelRequest(target);
            target.onPrepareLoad(this.setPlaceholder ? this.getPlaceholderDrawable() : null);
            return;
        }
        long started = System.nanoTime();
        Request finalRequest = this.createRequest(started);
        String key = Utils.createKey(finalRequest);
        if (MemoryPolicy.shouldReadFromMemoryCache(this.memoryPolicy) && (bitmap = this.loader.quickMemoryCacheCheck(key)) != null) {
            this.loader.cancelRequest(target);
            target.onBitmapLoaded(bitmap, LoadedFrom.MEMORY);
            return;
        }
        target.onPrepareLoad(this.setPlaceholder ? this.getPlaceholderDrawable() : null);
        TargetAction action = new TargetAction(this.loader, target, finalRequest, this.memoryPolicy, this.diskPolicy, this.errorDrawable, key, this.tag, this.errorResId);
        this.loader.enqueueAndSubmit(action);
    }

    public void into(RemoteViews remoteViews, int viewId, int notificationId, Notification notification) {
        this.into(remoteViews, viewId, notificationId, notification, null);
    }

    public void into(RemoteViews remoteViews, int viewId, int notificationId, Notification notification, String notificationTag) {
        if (remoteViews == null) {
            throw new IllegalArgumentException("RemoteViews must not be null.");
        }
        if (notification == null) {
            throw new IllegalArgumentException("Notification must not be null.");
        }
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with RemoteViews.");
        }
        if (this.placeholderDrawable != null || this.placeholderResId != 0 || this.errorDrawable != null) {
            throw new IllegalArgumentException("Cannot use placeholder or onError drawables with remote views.");
        }
        long started = System.nanoTime();
        Request request = this.createRequest(started);
        String key = Utils.createKey(request, new StringBuilder());
        RemoteViewsAction.NotificationAction action = new RemoteViewsAction.NotificationAction(this.loader, request, remoteViews, viewId, notificationId, notification, notificationTag, this.memoryPolicy, this.diskPolicy, key, this.tag, this.errorResId);
        this.performRemoteViewInto(action);
    }

    public void into(RemoteViews remoteViews, int viewId, int[] appWidgetIds) {
        long started = System.nanoTime();
        if (remoteViews == null) {
            throw new IllegalArgumentException("remoteViews must not be null.");
        }
        if (appWidgetIds == null) {
            throw new IllegalArgumentException("appWidgetIds must not be null.");
        }
        if (this.deferred) {
            throw new IllegalStateException("Fit cannot be used with remote views.");
        }
        if (this.placeholderDrawable != null || this.placeholderResId != 0 || this.errorDrawable != null) {
            throw new IllegalArgumentException("Cannot use placeholder or onError drawables with remote views.");
        }
        Request request = this.createRequest(started);
        String key = Utils.createKey(request, new StringBuilder());
        RemoteViewsAction.AppWidgetAction action = new RemoteViewsAction.AppWidgetAction(this.loader, request, remoteViews, viewId, appWidgetIds, this.memoryPolicy, this.diskPolicy, key, this.tag, this.errorResId);
        this.performRemoteViewInto(action);
    }

    public void into(ImageView target) {
        this.into(target, null);
    }

    public void into(ImageView target, Callback callback) {
        Bitmap bitmap;
        ThreadChecker.checkMain();
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (!this.builder.hasImage()) {
            this.loader.cancelRequest(target);
            if (this.setPlaceholder) {
                EnhanceDrawable.setPlaceholder(target, this.getPlaceholderDrawable());
            }
            return;
        }
        if (this.deferred) {
            if (this.builder.hasSize()) {
                throw new IllegalStateException("Fit cannot be used with resize.");
            }
            int width = target.getWidth();
            int height = target.getHeight();
            if (width == 0 || height == 0) {
                if (this.setPlaceholder) {
                    EnhanceDrawable.setPlaceholder(target, this.getPlaceholderDrawable());
                }
                this.loader.defer(target, new DeferredRequestCreator(this, target, callback));
                return;
            }
            this.builder.resize(width, height);
        }
        long started = System.nanoTime();
        Request request = this.createRequest(started);
        EasyLoaderLog.d("request: ", request.toString());
        String key = Utils.createKey(request);
        if (MemoryPolicy.shouldReadFromMemoryCache(this.memoryPolicy) && (bitmap = this.loader.quickMemoryCacheCheck(key)) != null) {
            this.loader.cancelRequest(target);
            EnhanceDrawable.setBitmap(target, this.loader.getContext(), bitmap, LoadedFrom.MEMORY, this.noFade, this.loader.isIndicatorsEnabled());
            if (callback != null) {
                callback.onSuccess();
            }
            return;
        }
        if (this.setPlaceholder) {
            EnhanceDrawable.setPlaceholder(target, this.getPlaceholderDrawable());
        }
        ImageViewAction action = new ImageViewAction(this.loader, target, request, this.memoryPolicy, this.diskPolicy, this.errorResId, this.errorDrawable, key, this.tag, callback, this.noFade);
        this.loader.enqueueAndSubmit(action);
    }

    private Drawable getPlaceholderDrawable() {
        if (this.placeholderResId != 0) {
            return this.loader.getContext().getResources().getDrawable(this.placeholderResId);
        }
        return this.placeholderDrawable;
    }

    private Request transformRequest(Request request) {
        if (this.requestTransformer != null) {
            Request transformed = this.requestTransformer.transformRequest(request);
            if (transformed == null) {
                throw new IllegalStateException("Request transformer " + this.requestTransformer.getClass().getCanonicalName() + " returned null for " + request);
            }
            return transformed;
        }
        return request;
    }

    private Request createRequest(long started) {
        Request request = this.transformRequest(this.builder.build());
        request.id = nextId.getAndIncrement();
        request.started = started;
        return request;
    }

    private void performRemoteViewInto(RemoteViewsAction action) {
        Bitmap bitmap;
        if (MemoryPolicy.shouldReadFromMemoryCache(this.memoryPolicy) && (bitmap = this.loader.quickMemoryCacheCheck(action.getKey())) != null) {
            action.onComplete(bitmap, LoadedFrom.MEMORY);
            return;
        }
        if (this.placeholderResId != 0) {
            action.setImageResource(this.placeholderResId);
        }
        this.loader.enqueueAndSubmit(action);
    }
}

