/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.request;

import android.content.ContentResolver;
import android.content.Context;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.request.RequestHandler;
import site.hanschen.easyloader.request.Result;

public class ContentStreamRequestHandler
extends RequestHandler {
    final Context context;

    public ContentStreamRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request request) {
        return request != null && request.uri != null && "content".equals(request.uri.getScheme());
    }

    @Override
    public Result handle(Request request) throws IOException {
        return new Result(this.getInputStream(request), LoadedFrom.DISK);
    }

    InputStream getInputStream(Request request) throws FileNotFoundException {
        ContentResolver contentResolver = this.context.getContentResolver();
        return contentResolver.openInputStream(request.uri);
    }
}

