/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.request;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import java.io.IOException;
import java.io.InputStream;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.request.RequestHandler;
import site.hanschen.easyloader.request.Result;

public class AssetRequestHandler
extends RequestHandler {
    private static final String ANDROID_ASSET = "android_asset";
    private static final int ASSET_PREFIX_LENGTH = "file:///android_asset/".length();
    private final Context context;
    private final Object lock = new Object();
    private AssetManager assetManager;

    public AssetRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request request) {
        if (request == null || request.uri == null) {
            return false;
        }
        Uri uri = request.uri;
        return "file".equals(uri.getScheme()) && !uri.getPathSegments().isEmpty() && ANDROID_ASSET.equals(uri.getPathSegments().get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result handle(Request request) throws IOException {
        if (this.assetManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.assetManager == null) {
                    this.assetManager = this.context.getAssets();
                }
            }
        }
        InputStream is = this.assetManager.open(AssetRequestHandler.getFilePath(request));
        return new Result(is, LoadedFrom.DISK);
    }

    private static String getFilePath(Request request) {
        return request.uri.toString().substring(ASSET_PREFIX_LENGTH);
    }
}

