/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.downloader;

import android.net.Uri;
import android.support.annotation.NonNull;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import site.hanschen.easyloader.bean.NetworkResponse;
import site.hanschen.easyloader.downloader.Downloader;
import site.hanschen.easyloader.downloader.ResponseException;
import site.hanschen.easyloader.log.EasyLoaderLog;

public class OkHttp3Downloader
implements Downloader {
    private final OkHttpClient client = new OkHttpClient.Builder().build();

    @Override
    public NetworkResponse load(@NonNull Uri uri) throws IOException {
        EasyLoaderLog.d("download", "download: " + uri.toString());
        Request.Builder builder = new Request.Builder().url(uri.toString());
        Response response = this.client.newCall(builder.build()).execute();
        int responseCode = response.code();
        if (responseCode >= 300) {
            response.body().close();
            throw new ResponseException(responseCode + " " + response.message(), responseCode);
        }
        return new NetworkResponse(response.body().byteStream(), response.body().contentLength());
    }
}

