/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.cache;

import java.io.File;
import java.io.IOException;
import site.hanschen.easyloader.cache.CacheManager;
import site.hanschen.easyloader.cache.DiskCacheWriteLocker;
import site.hanschen.easyloader.cache.diskcache.DiskLruCache;
import site.hanschen.easyloader.log.EasyLoaderLog;

public class LruDiskCache<V>
implements CacheManager<String, V> {
    private static final String TAG = "LruDiskCache";
    private static final int VALUE_COUNT = 1;
    private final DiskCacheWriteLocker writeLocker = new DiskCacheWriteLocker();
    private final File directory;
    private final long maxSize;
    private final int appVersion;
    private DiskLruCache diskLruCache;
    private FileConverter<V> converter;

    public LruDiskCache(File directory, long maxSize, int appVersion, FileConverter<V> converter) {
        if (directory == null || maxSize <= 0L || appVersion <= 0 || converter == null) {
            throw new IllegalArgumentException("directory == null || maxSize <= 0 || appVersion <= 0 || converter == null");
        }
        this.directory = directory;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.converter = converter;
    }

    private synchronized DiskLruCache getDiskCache() throws IOException {
        if (this.diskLruCache == null) {
            this.diskLruCache = DiskLruCache.open(this.directory, this.appVersion, 1, this.maxSize);
        }
        return this.diskLruCache;
    }

    @Override
    public V get(String key) {
        try {
            DiskLruCache.Value value = this.getDiskCache().get(key);
            if (value != null) {
                return this.converter.readFrom(value.getFile(0));
            }
        }
        catch (IOException e) {
            EasyLoaderLog.w(TAG, "Unable to get from disk cache");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, V value) {
        DiskLruCache diskCache;
        block11: {
            this.writeLocker.acquire(key);
            diskCache = this.getDiskCache();
            DiskLruCache.Value current = diskCache.get(key);
            if (current == null) break block11;
            this.writeLocker.release(key);
            return;
        }
        try {
            try {
                DiskLruCache.Editor editor = diskCache.edit(key);
                if (editor == null) {
                    throw new IllegalStateException("Had two simultaneous puts for: " + key);
                }
                try {
                    File file = editor.getFile(0);
                    if (this.converter.writeTo(value, file)) {
                        editor.commit();
                    }
                }
                finally {
                    editor.abortUnlessCommitted();
                }
            }
            catch (IOException e) {
                EasyLoaderLog.w(TAG, "Unable to put to disk cache" + e);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.writeLocker.release(key);
        }
    }

    @Override
    public V remove(String key) {
        try {
            this.getDiskCache().remove(key);
        }
        catch (IOException e) {
            EasyLoaderLog.w(TAG, "Unable to delete from disk cache: " + e);
        }
        return null;
    }

    @Override
    public long size() {
        try {
            return this.getDiskCache().size();
        }
        catch (IOException e) {
            EasyLoaderLog.w(TAG, "Unable to clear disk cache: " + e);
            return 0L;
        }
    }

    @Override
    public void resize(long maxSize) {
        try {
            this.getDiskCache().setMaxSize(maxSize);
        }
        catch (IOException e) {
            EasyLoaderLog.w(TAG, "Unable to resize disk cache: " + e);
        }
    }

    @Override
    public long maxSize() {
        try {
            return this.getDiskCache().getMaxSize();
        }
        catch (IOException e) {
            EasyLoaderLog.w(TAG, "Unable to get max size: " + e);
            return 0L;
        }
    }

    @Override
    public void clear() {
        try {
            this.getDiskCache().delete();
            this.resetDiskCache();
        }
        catch (IOException e) {
            EasyLoaderLog.w(TAG, "Unable to clear disk cache" + e);
        }
    }

    private synchronized void resetDiskCache() {
        this.diskLruCache = null;
    }

    public static interface FileConverter<V> {
        public V readFrom(File var1);

        public boolean writeTo(V var1, File var2);
    }
}

