/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.action;

import android.app.Notification;
import android.app.NotificationManager;
import android.appwidget.AppWidgetManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import site.hanschen.easyloader.EasyLoader;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.action.Action;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.util.Utils;

public abstract class RemoteViewsAction
extends Action<RemoteViewsTarget> {
    final RemoteViews remoteViews;
    final int viewId;
    private RemoteViewsTarget target;

    public RemoteViewsAction(EasyLoader loader, Request data, RemoteViews remoteViews, int viewId, int errorResId, int memoryPolicy, int diskPolicy, Object tag, String key) {
        super(loader, null, data, memoryPolicy, diskPolicy, errorResId, null, key, tag, false);
        this.remoteViews = remoteViews;
        this.viewId = viewId;
    }

    @Override
    public void onComplete(Bitmap result, LoadedFrom from) {
        this.remoteViews.setImageViewBitmap(this.viewId, result);
        this.update();
    }

    @Override
    public void onError() {
        if (this.errorResId != 0) {
            this.setImageResource(this.errorResId);
        }
    }

    @Override
    public RemoteViewsTarget getTarget() {
        if (this.target == null) {
            this.target = new RemoteViewsTarget(this.remoteViews, this.viewId);
        }
        return this.target;
    }

    public void setImageResource(int resId) {
        this.remoteViews.setImageViewResource(this.viewId, resId);
        this.update();
    }

    abstract void update();

    public static class NotificationAction
    extends RemoteViewsAction {
        private final int notificationId;
        private final String notificationTag;
        private final Notification notification;

        public NotificationAction(EasyLoader loader, Request data, RemoteViews remoteViews, int viewId, int notificationId, Notification notification, String notificationTag, int memoryPolicy, int diskPolicy, String key, Object tag, int errorResId) {
            super(loader, data, remoteViews, viewId, errorResId, memoryPolicy, diskPolicy, tag, key);
            this.notificationId = notificationId;
            this.notificationTag = notificationTag;
            this.notification = notification;
        }

        @Override
        void update() {
            NotificationManager manager = (NotificationManager)Utils.getService(this.loader.getContext(), "notification");
            manager.notify(this.notificationTag, this.notificationId, this.notification);
        }
    }

    public static class AppWidgetAction
    extends RemoteViewsAction {
        private final int[] appWidgetIds;

        public AppWidgetAction(EasyLoader loader, Request data, RemoteViews remoteViews, int viewId, int[] appWidgetIds, int memoryPolicy, int diskPolicy, String key, Object tag, int errorResId) {
            super(loader, data, remoteViews, viewId, errorResId, memoryPolicy, diskPolicy, tag, key);
            this.appWidgetIds = appWidgetIds;
        }

        @Override
        void update() {
            AppWidgetManager manager = AppWidgetManager.getInstance((Context)this.loader.getContext());
            manager.updateAppWidget(this.appWidgetIds, this.remoteViews);
        }
    }

    static class RemoteViewsTarget {
        final RemoteViews remoteViews;
        final int viewId;

        RemoteViewsTarget(RemoteViews remoteViews, int viewId) {
            this.remoteViews = remoteViews;
            this.viewId = viewId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteViewsTarget remoteViewsTarget = (RemoteViewsTarget)o;
            return this.viewId == remoteViewsTarget.viewId && this.remoteViews.equals(remoteViewsTarget.remoteViews);
        }

        public int hashCode() {
            return 31 * this.remoteViews.hashCode() + this.viewId;
        }
    }
}

