/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import site.hanschen.easyloader.AdjustableExecutorService;
import site.hanschen.easyloader.BitmapHunter;
import site.hanschen.easyloader.DeferredRequestCreator;
import site.hanschen.easyloader.Dispatcher;
import site.hanschen.easyloader.LoadedFrom;
import site.hanschen.easyloader.MemoryPolicy;
import site.hanschen.easyloader.Provider;
import site.hanschen.easyloader.QueueProcessType;
import site.hanschen.easyloader.action.Action;
import site.hanschen.easyloader.cache.CacheManager;
import site.hanschen.easyloader.cache.LruDiskCache;
import site.hanschen.easyloader.cache.LruMemoryCache;
import site.hanschen.easyloader.cache.SizeCalculator;
import site.hanschen.easyloader.callback.OnLoadListener;
import site.hanschen.easyloader.downloader.Downloader;
import site.hanschen.easyloader.downloader.OkHttp3Downloader;
import site.hanschen.easyloader.log.EasyLoaderLog;
import site.hanschen.easyloader.request.AssetRequestHandler;
import site.hanschen.easyloader.request.ContactsPhotoRequestHandler;
import site.hanschen.easyloader.request.ContentStreamRequestHandler;
import site.hanschen.easyloader.request.FileRequestHandler;
import site.hanschen.easyloader.request.MediaStoreRequestHandler;
import site.hanschen.easyloader.request.NetworkRequestHandler;
import site.hanschen.easyloader.request.RequestCreator;
import site.hanschen.easyloader.request.RequestHandler;
import site.hanschen.easyloader.request.RequestTransformer;
import site.hanschen.easyloader.request.ResourceRequestHandler;
import site.hanschen.easyloader.util.AppUtils;
import site.hanschen.easyloader.util.BitmapUtils;
import site.hanschen.easyloader.util.ThreadChecker;
import site.hanschen.easyloader.util.Utils;

public class EasyLoader
implements Provider {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile EasyLoader singleton;
    private final Context context;
    private final ReferenceQueue<Object> referenceQueue;
    private final Dispatcher dispatcher;
    private final List<RequestHandler> requestHandlers;
    private final CacheManager<String, Bitmap> memoryCache;
    private final CacheManager<String, Bitmap> diskCache;
    private final Bitmap.Config defaultBitmapConfig;
    private final RequestTransformer requestTransformer;
    private final OnLoadListener listener;
    private final CleanupThread cleanupThread;
    private final Map<Object, Action> targetToAction;
    private final Map<ImageView, DeferredRequestCreator> targetToDeferredRequestCreator;
    private final QueueProcessType queueProcessType;
    private boolean shutdown;
    private boolean indicatorsEnabled;
    static final Handler HANDLER;

    private EasyLoader(Context context, AdjustableExecutorService service, CacheManager<String, Bitmap> memoryCache, CacheManager<String, Bitmap> diskCache, OnLoadListener listener, List<RequestHandler> extraRequestHandlers, Bitmap.Config defaultBitmapConfig, RequestTransformer requestTransformer, Downloader downloader, QueueProcessType queueProcessType, boolean indicatorsEnabled, boolean loggingEnabled) {
        EasyLoaderLog.logEnable(loggingEnabled);
        this.context = context.getApplicationContext();
        this.memoryCache = memoryCache;
        this.diskCache = diskCache;
        this.listener = listener;
        this.defaultBitmapConfig = defaultBitmapConfig;
        this.requestTransformer = requestTransformer;
        this.queueProcessType = queueProcessType;
        this.indicatorsEnabled = indicatorsEnabled;
        ArrayList<RequestHandler> allRequestHandlers = new ArrayList<RequestHandler>();
        allRequestHandlers.add(new ResourceRequestHandler(context));
        allRequestHandlers.add(new ContactsPhotoRequestHandler(context));
        allRequestHandlers.add(new MediaStoreRequestHandler(context));
        allRequestHandlers.add(new ContentStreamRequestHandler(context));
        allRequestHandlers.add(new AssetRequestHandler(context));
        allRequestHandlers.add(new FileRequestHandler(context));
        allRequestHandlers.add(new NetworkRequestHandler(downloader));
        if (extraRequestHandlers != null) {
            allRequestHandlers.addAll(extraRequestHandlers);
        }
        this.requestHandlers = Collections.unmodifiableList(allRequestHandlers);
        this.dispatcher = new Dispatcher(context, service, HANDLER, memoryCache, diskCache);
        this.targetToAction = new WeakHashMap<Object, Action>();
        this.targetToDeferredRequestCreator = new WeakHashMap<ImageView, DeferredRequestCreator>();
        this.referenceQueue = new ReferenceQueue();
        this.cleanupThread = new CleanupThread(this.referenceQueue, HANDLER);
        this.cleanupThread.start();
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.memoryCache.clear();
        this.cleanupThread.shutdown();
        this.dispatcher.shutdown();
        for (DeferredRequestCreator deferredRequestCreator : this.targetToDeferredRequestCreator.values()) {
            deferredRequestCreator.cancel();
        }
        this.targetToDeferredRequestCreator.clear();
        this.shutdown = true;
    }

    private void cancelExistingRequest(Object target) {
        ImageView targetImageView;
        DeferredRequestCreator deferredRequestCreator;
        ThreadChecker.checkMain();
        Action action = this.targetToAction.remove(target);
        if (action != null) {
            action.cancel();
            this.dispatcher.dispatchCancel(action);
        }
        if (target instanceof ImageView && (deferredRequestCreator = this.targetToDeferredRequestCreator.remove(targetImageView = (ImageView)target)) != null) {
            deferredRequestCreator.cancel();
        }
    }

    public void submit(Action action) {
        this.dispatcher.dispatchSubmit(action);
    }

    public void enqueueAndSubmit(Action action) {
        Object target = action.getTarget();
        if (target != null && this.targetToAction.get(target) != action) {
            this.cancelExistingRequest(target);
            this.targetToAction.put(target, action);
        }
        this.submit(action);
    }

    public <T> void cancelRequest(T target) {
        if (target == null) {
            throw new IllegalArgumentException("view cannot be null.");
        }
        this.cancelExistingRequest(target);
    }

    private void complete(BitmapHunter hunter) {
        boolean hasMultiple;
        Action single = hunter.getAction();
        List<Action> joined = hunter.getActions();
        boolean bl = hasMultiple = joined != null && !joined.isEmpty();
        if (single == null && !hasMultiple) {
            return;
        }
        Uri uri = hunter.getData().uri;
        Exception exception = hunter.getException();
        Bitmap result = hunter.getResult();
        LoadedFrom from = hunter.getLoadedFrom();
        if (single != null) {
            this.deliverAction(result, from, single);
        }
        if (hasMultiple) {
            int n = joined.size();
            for (int i = 0; i < n; ++i) {
                Action join = joined.get(i);
                this.deliverAction(result, from, join);
            }
        }
        if (this.listener != null && exception != null) {
            this.listener.onLoadFailed(this, uri, exception);
        }
    }

    public void defer(ImageView view, DeferredRequestCreator request) {
        if (this.targetToDeferredRequestCreator.containsKey(view)) {
            this.cancelExistingRequest(view);
        }
        this.targetToDeferredRequestCreator.put(view, request);
    }

    public Bitmap quickMemoryCacheCheck(String key) {
        return this.memoryCache.get(key);
    }

    void resumeAction(Action action) {
        Bitmap bitmap = null;
        if (MemoryPolicy.shouldReadFromMemoryCache(action.getMemoryPolicy())) {
            bitmap = this.quickMemoryCacheCheck(action.getKey());
        }
        if (bitmap != null) {
            this.deliverAction(bitmap, LoadedFrom.MEMORY, action);
        } else {
            this.enqueueAndSubmit(action);
        }
    }

    private void deliverAction(Bitmap result, LoadedFrom from, Action action) {
        if (action.isCancelled()) {
            return;
        }
        if (!action.willReplay()) {
            this.targetToAction.remove(action.getTarget());
        }
        if (result != null) {
            if (from == null) {
                throw new AssertionError((Object)"LoadedFrom cannot be null.");
            }
            action.onComplete(result, from);
        } else {
            action.onError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EasyLoader with(@NonNull Context context) {
        if (singleton != null) return singleton;
        Class<EasyLoader> clazz = EasyLoader.class;
        synchronized (EasyLoader.class) {
            if (singleton != null) return singleton;
            singleton = new Builder(context).downloader(new OkHttp3Downloader()).indicatorsEnabled(false).logEnable(true).maxMemoryCacheSize(0x3C00000L).maxDiskCacheSize(0x6400000L).queueProcessType(QueueProcessType.LIFO).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public RequestCreator load(Uri uri) {
        return new RequestCreator(this, uri, 0, this.requestTransformer, this.dispatcher);
    }

    public RequestCreator load(int resourceId) {
        if (resourceId == 0) {
            throw new IllegalArgumentException("Resource ID must not be zero.");
        }
        return new RequestCreator(this, null, resourceId, this.requestTransformer, this.dispatcher);
    }

    public RequestCreator load(File file) {
        if (file == null) {
            return new RequestCreator(this, null, 0, this.requestTransformer, this.dispatcher);
        }
        return this.load(Uri.fromFile((File)file));
    }

    public RequestCreator load(String uri) {
        if (uri == null) {
            return new RequestCreator(this, null, 0, this.requestTransformer, this.dispatcher);
        }
        if (uri.trim().length() == 0) {
            throw new IllegalArgumentException("Path must not be empty.");
        }
        return this.load(Uri.parse((String)uri));
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public ReferenceQueue<Object> getReferenceQueue() {
        return this.referenceQueue;
    }

    @Override
    public List<RequestHandler> getRequestHandlers() {
        return this.requestHandlers;
    }

    @Override
    public CacheManager<String, Bitmap> getMemoryCacheManager() {
        return this.memoryCache;
    }

    @Override
    public CacheManager<String, Bitmap> getDiskCacheManager() {
        return this.diskCache;
    }

    @Override
    public Bitmap.Config getDefaultBitmapConfig() {
        return this.defaultBitmapConfig;
    }

    @Override
    public QueueProcessType getQueueProcessType() {
        return this.queueProcessType;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isIndicatorsEnabled() {
        return this.indicatorsEnabled;
    }

    static {
        HANDLER = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 8: {
                        List batch = (List)msg.obj;
                        int n = batch.size();
                        for (int i = 0; i < n; ++i) {
                            BitmapHunter hunter = (BitmapHunter)batch.get(i);
                            hunter.getLoader().complete(hunter);
                        }
                        break;
                    }
                    case 3: {
                        Action action = (Action)msg.obj;
                        action.getLoader().cancelExistingRequest(action.getTarget());
                        break;
                    }
                    case 13: {
                        List batch = (List)msg.obj;
                        int n = batch.size();
                        for (int i = 0; i < n; ++i) {
                            Action action = (Action)batch.get(i);
                            action.getLoader().resumeAction(action);
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown dispatcherHandler message received: " + msg.what));
                    }
                }
            }
        };
    }

    private static class Builder {
        private final Context context;
        private AdjustableExecutorService service;
        private boolean logEnable;
        private boolean indicatorsEnabled;
        private CacheManager<String, Bitmap> memoryCacheManager;
        private CacheManager<String, Bitmap> diskCacheManager;
        private File cacheDirectory;
        private OnLoadListener listener;
        private RequestTransformer transformer;
        private Bitmap.Config defaultBitmapConfig;
        private Downloader downloader;
        private QueueProcessType queueProcessType;
        private List<RequestHandler> requestHandlers;
        private long maxMemoryCacheSize;
        private long maxDiskCacheSize;

        private Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context can not be null");
            }
            this.context = context.getApplicationContext();
        }

        Builder logEnable(boolean enable) {
            this.logEnable = enable;
            return this;
        }

        Builder indicatorsEnabled(boolean enable) {
            this.indicatorsEnabled = enable;
            return this;
        }

        Builder memoryCache(CacheManager<String, Bitmap> memoryCache) {
            this.memoryCacheManager = memoryCache;
            return this;
        }

        Builder diskCache(CacheManager<String, Bitmap> diskCache) {
            this.diskCacheManager = diskCache;
            return this;
        }

        Builder cacheDirectory(File cacheDir) {
            this.cacheDirectory = cacheDir;
            return this;
        }

        Builder onLoadListener(OnLoadListener onLoadListener) {
            this.listener = onLoadListener;
            return this;
        }

        Builder RequestTransformer(RequestTransformer transformer) {
            this.transformer = transformer;
            return this;
        }

        Builder defaultBitmapConfig(Bitmap.Config config) {
            this.defaultBitmapConfig = config;
            return this;
        }

        Builder downloader(Downloader downloader) {
            this.downloader = downloader;
            return this;
        }

        Builder queueProcessType(QueueProcessType queueProcessType) {
            this.queueProcessType = queueProcessType;
            return this;
        }

        public Builder requestHandlers(List<RequestHandler> handlers) {
            this.requestHandlers = handlers;
            return this;
        }

        Builder maxMemoryCacheSize(long maxMemoryCacheSize) {
            this.maxMemoryCacheSize = maxMemoryCacheSize;
            return this;
        }

        Builder maxDiskCacheSize(long maxDiskCacheSize) {
            this.maxDiskCacheSize = maxDiskCacheSize;
            return this;
        }

        EasyLoader build() {
            if (this.service == null) {
                this.service = new AdjustableExecutorService();
            }
            if (this.maxMemoryCacheSize == 0L) {
                this.maxMemoryCacheSize = Utils.calculateMemoryCacheSize(this.context);
            }
            if (this.memoryCacheManager == null) {
                this.memoryCacheManager = new LruMemoryCache<String, Bitmap>(this.maxMemoryCacheSize, new SizeCalculator<Bitmap>(){

                    @Override
                    public int getSizeOf(Bitmap value) {
                        return BitmapUtils.getBitmapBytes(value);
                    }
                });
            }
            if (this.diskCacheManager == null) {
                File directory;
                if (this.cacheDirectory == null && (directory = this.context.getExternalCacheDir()) != null) {
                    this.cacheDirectory = new File(directory, "easy_loader_disk_cache");
                }
                if (this.cacheDirectory != null && (this.cacheDirectory.mkdirs() || this.cacheDirectory.exists() && this.cacheDirectory.isDirectory())) {
                    if (this.maxDiskCacheSize == 0L) {
                        this.maxDiskCacheSize = Utils.calculateDiskCacheSize(this.cacheDirectory);
                    }
                    this.diskCacheManager = new LruDiskCache<Bitmap>(this.cacheDirectory, this.maxDiskCacheSize, AppUtils.getVersionCode(this.context), new LruDiskCache.FileConverter<Bitmap>(){

                        @Override
                        public Bitmap readFrom(File file) {
                            return BitmapFactory.decodeFile((String)file.getAbsolutePath(), null);
                        }

                        @Override
                        public boolean writeTo(Bitmap value, File to) {
                            try {
                                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(to));
                                value.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
                                bos.flush();
                                bos.close();
                                return true;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return false;
                            }
                        }
                    });
                }
            }
            if (this.transformer == null) {
                this.transformer = RequestTransformer.IDENTITY;
            }
            if (this.downloader == null) {
                this.downloader = new OkHttp3Downloader();
            }
            if (this.queueProcessType == null) {
                this.queueProcessType = QueueProcessType.LIFO;
            }
            return new EasyLoader(this.context, this.service, this.memoryCacheManager, this.diskCacheManager, this.listener, this.requestHandlers, this.defaultBitmapConfig, this.transformer, this.downloader, this.queueProcessType, this.indicatorsEnabled, this.logEnable);
        }
    }

    private static class CleanupThread
    extends Thread {
        private final ReferenceQueue<Object> referenceQueue;
        private final Handler handler;

        CleanupThread(ReferenceQueue<Object> referenceQueue, Handler handler) {
            this.referenceQueue = referenceQueue;
            this.handler = handler;
            this.setDaemon(true);
            this.setName("EasyLoader-refQueue");
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            try {
                while (true) {
                    Action.RequestWeakReference remove;
                    if ((remove = (Action.RequestWeakReference)this.referenceQueue.remove(1000L)) == null) {
                        continue;
                    }
                    Message message = this.handler.obtainMessage();
                    message.what = 3;
                    message.obj = remove.getAction();
                    this.handler.sendMessage(message);
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException(e);
                    }
                });
            }
        }

        void shutdown() {
            this.interrupt();
        }
    }
}

