/*
 * Decompiled with CFR 0.152.
 */
package site.hanschen.easyloader.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.StatFs;
import android.provider.Settings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import site.hanschen.easyloader.request.Request;
import site.hanschen.easyloader.util.MD5Utils;

public final class Utils {
    public static final String THREAD_PREFIX = "EasyLoader-";
    public static final String THREAD_IDLE_NAME = "EasyLoader-Idle";
    private static final int MIN_DISK_CACHE_SIZE = 0x500000;
    private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
    static final int THREAD_LEAK_CLEANING_MS = 1000;
    public static final String OWNER_MAIN = "Main";
    public static final String OWNER_DISPATCHER = "Dispatcher";
    public static final String OWNER_HUNTER = "Hunter";
    public static final String VERB_CREATED = "created";
    public static final String VERB_CHANGED = "changed";
    public static final String VERB_IGNORED = "ignored";
    public static final String VERB_ENQUEUED = "enqueued";
    public static final String VERB_CANCELED = "canceled";
    public static final String VERB_BATCHED = "batched";
    public static final String VERB_RETRYING = "retrying";
    public static final String VERB_EXECUTING = "executing";
    public static final String VERB_DECODED = "decoded";
    public static final String VERB_TRANSFORMED = "transformed";
    public static final String VERB_JOINED = "joined";
    public static final String VERB_REMOVED = "removed";
    public static final String VERB_DELIVERED = "delivered";
    public static final String VERB_REPLAYING = "replaying";
    public static final String VERB_COMPLETED = "completed";
    public static final String VERB_ERRORED = "errored";
    public static final String VERB_PAUSED = "paused";
    public static final String VERB_RESUMED = "resumed";
    static final StringBuilder MAIN_THREAD_KEY_BUILDER = new StringBuilder();
    private static final int WEBP_FILE_HEADER_SIZE = 12;
    private static final String WEBP_FILE_HEADER_RIFF = "RIFF";
    private static final String WEBP_FILE_HEADER_WEBP = "WEBP";

    private Utils() {
    }

    public static <T> T checkNotNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    @TargetApi(value=18)
    static long calculateDiskCacheSize(File dir) {
        long size = 0x500000L;
        try {
            StatFs statFs = new StatFs(dir.getAbsolutePath());
            long blockCount = Build.VERSION.SDK_INT < 18 ? (long)statFs.getBlockCount() : statFs.getBlockCountLong();
            long blockSize = Build.VERSION.SDK_INT < 18 ? (long)statFs.getBlockSize() : statFs.getBlockSizeLong();
            long available = blockCount * blockSize;
            size = available / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Math.max(Math.min(size, 0x3200000L), 0x500000L);
    }

    static int calculateMemoryCacheSize(Context context) {
        ActivityManager am = (ActivityManager)Utils.getService(context, "activity");
        boolean largeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClass = am.getMemoryClass();
        if (largeHeap && Build.VERSION.SDK_INT >= 11) {
            memoryClass = ActivityManagerHoneycomb.getLargeMemoryClass(am);
        }
        return (int)(0x100000L * (long)memoryClass / 7L);
    }

    public static boolean isAirplaneModeOn(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        try {
            if (Build.VERSION.SDK_INT < 17) {
                return Settings.System.getInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)0) != 0;
            }
            return Settings.Global.getInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)0) != 0;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static <T> T getService(Context context, String service) {
        return (T)context.getSystemService(service);
    }

    public static boolean hasPermission(Context context, String permission2) {
        return context.checkCallingOrSelfPermission(permission2) == 0;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            byteArrayOutputStream.write(buffer, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isWebPFile(InputStream stream) throws IOException {
        byte[] fileHeaderBytes = new byte[12];
        boolean isWebPFile = false;
        if (stream.read(fileHeaderBytes, 0, 12) == 12) {
            isWebPFile = WEBP_FILE_HEADER_RIFF.equals(new String(fileHeaderBytes, 0, 4, "US-ASCII")) && WEBP_FILE_HEADER_WEBP.equals(new String(fileHeaderBytes, 8, 4, "US-ASCII"));
        }
        return isWebPFile;
    }

    public static void flushStackLocalLeaks(Looper looper) {
        Handler handler = new Handler(looper){

            public void handleMessage(Message msg) {
                this.sendMessageDelayed(this.obtainMessage(), 1000L);
            }
        };
        handler.sendMessageDelayed(handler.obtainMessage(), 1000L);
    }

    public static String createKey(Request data) {
        String result = Utils.createKey(data, MAIN_THREAD_KEY_BUILDER);
        MAIN_THREAD_KEY_BUILDER.setLength(0);
        return result;
    }

    public static String createKey(Request data, StringBuilder builder) {
        int KEY_PADDING = 50;
        int KEY_SEPARATOR = 10;
        if (data.stableKey != null) {
            builder.ensureCapacity(data.stableKey.length() + 50);
            builder.append(data.stableKey);
        } else if (data.uri != null) {
            String path = data.uri.toString();
            builder.ensureCapacity(path.length() + 50);
            builder.append(path);
        } else {
            builder.ensureCapacity(50);
            builder.append(data.resourceId);
        }
        builder.append('\n');
        if (data.rotationDegrees != 0.0f) {
            builder.append("rotation:").append(data.rotationDegrees);
            if (data.hasRotationPivot) {
                builder.append('@').append(data.rotationPivotX).append('x').append(data.rotationPivotY);
            }
            builder.append('\n');
        }
        if (data.hasSize()) {
            builder.append("resize:").append(data.targetWidth).append('x').append(data.targetHeight);
            builder.append('\n');
        }
        if (data.centerCrop) {
            builder.append("centerCrop").append('\n');
        } else if (data.centerInside) {
            builder.append("centerInside").append('\n');
        }
        if (data.transformations != null) {
            int count = data.transformations.size();
            for (int i = 0; i < count; ++i) {
                builder.append(data.transformations.get(i).key());
                builder.append('\n');
            }
        }
        return MD5Utils.getMD5(builder.toString());
    }

    @TargetApi(value=12)
    private static class BitmapHoneycombMR1 {
        private BitmapHoneycombMR1() {
        }

        static int getByteCount(Bitmap bitmap) {
            return bitmap.getByteCount();
        }
    }

    private static class EasyLoaderThread
    extends Thread {
        public EasyLoaderThread(Runnable r) {
            super(r);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    public static class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            return new EasyLoaderThread(r);
        }
    }

    @TargetApi(value=11)
    private static class ActivityManagerHoneycomb {
        private ActivityManagerHoneycomb() {
        }

        static int getLargeMemoryClass(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }
}

